% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{pareto}
\alias{pareto}
\alias{dpareto}
\alias{qpareto}
\alias{ppareto}
\alias{rpareto}
\title{Pareto Distribution}
\usage{
dpareto(x, scale = 1, shape, log = FALSE)

qpareto(q, scale = 1, shape, lower.tail = TRUE, log.p = FALSE)

ppareto(p, scale = 1, shape, lower.tail = TRUE, log.p = FALSE)

rpareto(n, scale = 1, shape)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{scale}{alpha parameter.}

\item{shape}{k parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
dpareto gives the density, ppareto gives the distribution function,
qpareto gives the quantile function, and rpareto generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the Pareto distribution with parameters scale and shape.
The functions are wrappers on the equivalent VGAM functions.
}
\examples{
x <- rpareto(1000,1,0.1)
hist(log(x),freq=FALSE,col='gray',border='white')
hist(x,freq=FALSE,col='gray',border='white')
curve(dpareto(x,1,0.1),add=TRUE,col='red4',lwd=2)
}
\seealso{
\code{\link[VGAM]{dpareto}}
}
