% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llog.R
\name{llog}
\alias{llog}
\alias{dllog}
\alias{qllog}
\alias{pllog}
\alias{rllog}
\title{Log-Logistic Distribution}
\usage{
dllog(x, shape = 1, scale = 1, log = FALSE)

qllog(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

pllog(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

rllog(n, shape = 1, scale = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape}{shape parameter.}

\item{scale}{scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{n}{number of observations.}
}
\value{
dllog gives the density, pllog gives the distribution function,
qllog gives the quantile function, and rllog generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the log-logistic distribution with \code{shape} and \code{scale} parameters.
}
\details{
The functions are wrappers to export the identical functions from the FAdist package.
}
\examples{
x <- rllog(1000)
hist(x,freq=FALSE,col='gray',border='white')
curve(dllog(x),add=TRUE,col='red4',lwd=2)
}
\seealso{
\code{\link[FAdist]{dllog}}
}
