% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nebula.R
\name{nebula.bin.train}
\alias{nebula.bin.train}
\title{Nonparametric empirical Bayes classifier using latent annotations: binary indicators; training}
\usage{
nebula.bin.train(pi0, pi1, n0, n1, I, d = 25, maxit = 200,
  tol = 1e-04, verbose = FALSE)
}
\arguments{
\item{pi0, pi1}{p x 1 vectors of control and case minor allele frequencies, respectively; IMPORTANT: must be relative to the same allele in both cases and controls}

\item{n0, n1}{number of controls and number of cases, respectively}

\item{I}{p x 1 vector of binary indicators}

\item{d}{if a single number, G0 and G1 are estimated on d x d grids; if a two-component vector (d0,d1), G0 and G1 are estimated on d0 x d1 grids}

\item{maxit}{maximum number of EM iterations}

\item{tol}{error tolerance}

\item{verbose}{TRUE to print the error attained by each EM iteration}
}
\value{
\item{neb0}{output of neb.train using only SNPs with I==0}
\item{neb1}{output of neb.train using only SNPs with I==1}
\item{I}{binary indicator}
}
\description{
Assumes that binary indicators for each SNP are available; e.g. indicate whether the SNP is an eQTL. Treats the true control and case minor allele frequencies for SNPs with indicators equal to 0 and 1 as random triples from bivariate prior distributions G0 and G1, and estimates the optimal Bayesian classifier given G0 and G1. Nonparametric maximum likelihood is used as a plug-in estimator for G0 and G1.
}
\examples{
p <- 1000; ## number of snps
I <- rep(0,p); I[1:10] <- 1; ## which snps are causal
set.seed(1); pi0 <- runif(p,0.1,0.5); ## control minor allele frequencies
set.seed(1); ors <- runif(sum(I),-1,1); ## odds ratios
pi1 <- pi0;
pi1[I==1] <- expit(ors+logit(pi0[I==1]));
set.seed(1); lam <- rep(0,p); lam[I==1] <- rchisq(sum(I==1),1,25); ## ncps
## training data
n0 <- 100; ## number of controls
X0 <- t(replicate(n0,rbinom(p,2,pi0))); ## controls
n1 <- 50; ## number of cases
X1 <- t(replicate(n1,rbinom(p,2,pi1))); ## cases
T <- rchisq(p,1,lam); ## chi-square statistics
nebula <- nebula.bin.train(colMeans(X0)/2,colMeans(X1)/2,n0,n1,I,d=c(20,25));
par(mfrow=c(1,2));
contour(nebula$neb0$Pi0,nebula$neb0$Pi1,apply(nebula$neb0$g,c(1,2),sum));
points(pi0[I==0],pi1[I==0]);
contour(nebula$neb1$Pi0,nebula$neb1$Pi1,apply(nebula$neb1$g,c(1,2),sum));
points(pi0[I==1],pi1[I==1]);

}
