% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neb.R
\name{neb.train}
\alias{neb.train}
\title{Nonparametric empirical Bayes classifier without annotations; training}
\usage{
neb.train(pi0, pi1, n0, n1, d = 25, maxit = 200, tol = 1e-04,
  verbose = FALSE)
}
\arguments{
\item{pi0, pi1}{p x 1 vectors of control and case minor allele frequencies, respectively; IMPORTANT: must be relative to the same allele in both cases and controls}

\item{n0, n1}{number of controls and number of cases, respectively}

\item{d}{if a single number, G is estimated on a d x d grid; if a two-component vector (d0,d1), G is estimated on a d0 x d1 grid}

\item{maxit}{maximum number of EM iterations}

\item{tol}{error tolerance}

\item{verbose}{TRUE to print the error attained by each EM iteration}
}
\value{
\item{Pi0}{grid points for estimating the distribution of the control minor allele frequencies}
\item{Pi1}{grid points for estimating the distribution of the case minor allele frequencies}
\item{D0}{conditional density matrix for controls}
\item{D1}{conditional density matrix for cases}
\item{g}{estimated mixing probability mass function}
\item{P}{proportion of cases}
}
\description{
Treats the control and case minor allele frequencies as random tuples from a bivariate prior distribution G and then estimates the optimal Bayesian classifier given G. Nonparametric maximum likelihood is used as a plug-in estimator for G.
}
\examples{
p <- 1000; ## number of snps
I <- rep(0,p); I[1:10] <- 1; ## which snps are causal
set.seed(1); pi0 <- runif(p,0.1,0.5); ## control minor allele frequencies
set.seed(1); ors <- runif(sum(I),-1,1); ## odds ratios
pi1 <- pi0;
pi1[I==1] <- expit(ors+logit(pi0[I==1]));
## training data
n0 <- 100; ## number of controls
X0 <- t(replicate(n0,rbinom(p,2,pi0))); ## controls
n1 <- 50; ## number of cases
X1 <- t(replicate(n1,rbinom(p,2,pi1))); ## cases
neb <- neb.train(colMeans(X0)/2,colMeans(X1)/2,n0,n1,d=c(20,25));
contour(neb$Pi0,neb$Pi1,neb$g);
points(pi0,pi1);

}

