% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specc_cluster.R
\name{get_samp_class}
\alias{get_samp_class}
\title{Determining cancer subtypes using unsupervised spectral clustering algorithm.}
\usage{
get_samp_class(
  Path_ES,
  sur,
  seed_num = 50,
  cox_pval = 0.05,
  min.nc = 2,
  max.nc = 5
)
}
\arguments{
\item{Path_ES}{Single-sample mutation-based pathway enrichment score(ssMutPES) profiles.The file can be generated by the function `get_RWR_ES`.}

\item{sur}{A matrix containing the samples' survival time and survival states.}

\item{seed_num}{The number of seeds for iterating to select the optimal clustering result.}

\item{cox_pval}{A custom threshold to filter characteristic pathways, default to 0.05.}

\item{min.nc}{Minimal number of clusters.}

\item{max.nc}{maximal number of clusters,greater or equal to min.nc.}
}
\value{
A list containing the filtered pathways,the best seed for clustering,and cancer subtyoe labels .
}
\description{
The function `get_samp_class` using spectral clustering algorithm to obtain cancer subtype labels.
}
\examples{
#load the data.
surv_path <- system.file("extdata","sur.Rdata",package = "ssMutPA")
load(surv_path)
data(Path_ES)
#perform function `get_samp_class`.
\donttest{
res<-get_samp_class(Path_ES,sur,seed_num=5,cox_pval=0.05,min.nc = 2,max.nc =5)
}
}
