% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locOuts_methods.R
\name{plot.locOuts}
\alias{plot.locOuts}
\title{Diagnostic Plots for Local Outlier Detection}
\usage{
\method{plot}{locOuts}(
  x,
  type = c("hist", "spatial", "lines", "3D"),
  colour = "all",
  focus = NULL,
  pos = NULL,
  alpha = 0.3,
  data = NULL,
  add_map = TRUE,
  ...
)
}
\arguments{
\item{x}{a locOuts object obtained by the function \code{\link[ssMRCD]{local_outliers_ssMRCD}}.}

\item{type}{vector containing the types of plots that should be plotted, possible values \code{c("hist", "spatial", "lines", "3D")}.}

\item{colour}{character specifying the color scheme (see details). Possible values \code{"all", "onlyOuts", "outScore"}.}

\item{focus}{an integer being the index of the observation whose neighborhood should be analysed more closely.}

\item{pos}{integer specifying the position of the text "cut-off" in the histogram (see \code{\link{par}}).}

\item{alpha}{scalar specifying the transparancy level of the points plotted for plot type \code{"spatial", "3D"} and \code{"lines"}.}

\item{data}{optional data frame or matrix used for plot of type \code{"line"}. Will be used to plot lines based scaled \code{data} instead of the data used for local outlier detection.}

\item{add_map}{TRUE if a map should be plotted along the line plot (\code{type = "lines"}).}

\item{...}{further parameters passed on to base-R plotting functions.}
}
\value{
Returns plots regarding next distances and spatial context.
}
\description{
This function plots different diagnostic plots for local outlier detection.
It can be applied to an object of class \code{"locOuts"} which is the output of the function \code{\link[ssMRCD]{local_outliers_ssMRCD}}.
}
\details{
Regarding the parameter \code{type} the value \code{"hist"} corresponds to a plot of the
histogram of the next distances together with the used cutoff-value.
When using \code{"spatial"} the coordinates of each observation are plotted and colorized according to the color setting.
The \code{"lines"} plot is used with the index \code{focus} of one observation whose out/inlyingness to its neighborhood
should by plotted. The whole data set is scaled to the range [0,1] and the scaled value of the selected observation and
its neighbors are plotted. Outliers are plotted in orange.
The \code{"3D"} setting leads to a 3D-plot using the colour setting as height.
The view can be adapted using the parameters \code{theta} and \code{phi}. \cr \cr
For the \code{colour} setting possible values are \code{"all"} (all next distances are
used and colored in an orange palette), \code{"onlyOuts"} (only outliers are
plotted in orange, inliers are plotted in grey) and \code{"outScore"} (the next
distance divided by the cutoff value is used to colourize the points; inliers are colorized in blue, outliers in orange).
}
\examples{
# set seed
set.seed(1)

# make locOuts object
data = matrix(rnorm(2000), ncol = 4)
coords = matrix(rnorm(1000), ncol = 2)
N_assignments = sample(1:10, 500, replace = TRUE)
lambda = 0.3

# local outlier detection
outs = local_outliers_ssMRCD(data = data,
                             coords = coords,
                             N_assignments = N_assignments,
                             lambda = lambda,
                             k = 10)

# plot results
plot(outs, type = "hist")
plot(outs, type = "spatial", colour = "outScore")
plot(outs, type = "3D", colour = "outScore", theta = 0)
plot(outs, type ="lines", focus = outs$outliers[1])
}
\seealso{
\code{\link[ssMRCD]{local_outliers_ssMRCD}}
}
