% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_outliers_ssMRCD.R
\name{local_outliers_ssMRCD}
\alias{local_outliers_ssMRCD}
\title{Local Outlier Detection Technique based on ssMRCD}
\usage{
local_outliers_ssMRCD(
  data,
  coords,
  N_assignments,
  lambda,
  weights = NULL,
  k = NULL,
  dist = NULL
)
}
\arguments{
\item{data}{data matrix with measured values.}

\item{coords}{matrix of coordinates of observations.}

\item{N_assignments}{vector of neighborhood assignments.}

\item{lambda}{scalar used for spatial smoothing (see also \code{\link[ssMRCD]{ssMRCD}}).}

\item{weights}{weight matrix used in \code{\link[ssMRCD]{ssMRCD}}.}

\item{k}{integer, if given the \code{k} nearest neighbors per observations are used to calculate next distances. Default value is \code{k = NULL}.}

\item{dist}{scalar, if given the neighbors closer than given distance are used for next distances. If \code{dist} is given, \code{dist} is used, otherwise \code{k} is used.}
}
\value{
Returns an object of class \code{"locOuts"} with following components:\tabular{ll}{
   \code{outliers} \tab indices of found outliers. \cr
   \tab \cr
   \code{next_distance} \tab vector of next distances for all observations. \cr
   \tab \cr
   \code{cutoff} \tab upper fence of adjusted boxplot (see \code{\link[robustbase]{adjbox}}) used as cutoff value for next distances. \cr
   \tab \cr
   \code{coords} \tab matrix of observation coordinates.\cr
   \tab \cr
   \code{data} \tab matrix of observation values. \cr
   \tab \cr
   \code{N_assignments} \tab vector of neighborhood assignments. \cr
   \tab \cr
   \code{k, dist} \tab specifications regarding neighbor comparisons. \cr
   \tab \cr
   \code{centersN} \tab coordinates of centers of neighborhoods. \cr
   \tab \cr
   \code{matneighbor} \tab matrix storing information which observations where used to calculate next distance for each observation (per row). 1 indicates it is used. \cr
   \tab \cr
   \code{ssMRCD} \tab object of class \code{"ssMRCD"} and output of \code{\link[ssMRCD]{ssMRCD}} covariance estimation. \cr
}
}
\description{
This function applies the local outlier detection method based on the spatially
smoothed MRCD estimator developed in Puchhammer and Filzmoser (2023).
}
\examples{
# data construction
data = matrix(rnorm(2000), ncol = 4)
coords = matrix(rnorm(1000), ncol = 2)
N_assignments = sample(1:10, 500, replace = TRUE)
lambda = 0.3

# apply function
outs = local_outliers_ssMRCD(data = data,
                             coords = coords,
                             N_assignments = N_assignments,
                             lambda = lambda,
                             k = 10)
outs
}
\references{
Puchhammer P. and Filzmoser P. (2023): Spatially smoothed robust covariance estimation for local outlier detection. \doi{10.48550/arXiv.2305.05371}
}
\seealso{
See also functions \code{\link[ssMRCD]{ssMRCD}, \link[ssMRCD]{plot.locOuts}, \link[ssMRCD]{summary.locOuts}}.
}
