% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_sql_deps.R
\name{tar_sql_deps}
\alias{tar_sql_deps}
\title{List SQL query dependencies.}
\usage{
tar_sql_deps(path)
}
\arguments{
\item{path}{Character vector, path to one or more SQL queries.}
}
\value{
Character vector of the names of targets
  that are dependencies of the SQL query.
}
\description{
List the target dependencies of one or more SQL queries.
}
\examples{
lines <- c(
  "-- !preview conn=DBI::dbConnect(RSQLite::SQLite())",
  "-- targets::tar_load(data1)",
  "-- targets::tar_read(data2)",
  "select 1 as my_col",
  ""
)
query <- tempfile()
writeLines(lines, query)
tar_sql_deps(query)
}
\concept{SQL query utilities}
