% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSample.MarginalScalar.R
\name{genSample.MarginalScalar}
\alias{genSample.MarginalScalar}
\title{Generating Monte Carlo sample from an uncertain object of a class 
'MarginalScalar'}
\usage{
\method{genSample}{MarginalScalar}(UMobject, n, samplemethod, p = 0,
  asList = TRUE, ...)
}
\arguments{
\item{UMobject}{uncertain object defined using defineUM().}

\item{n}{Integer. Number of Monte Carlo realizations.}

\item{samplemethod}{"randomSampling" or "stratifiedSampling".}

\item{p}{A vector of quantiles. Optional. Only required if sample method is
"stratifiedSampling".}

\item{asList}{logical. If asList = TRUE returns list of all samples as a list. 
If asList = FALSE returns samples in a format of distribution parameters in UMobject.}

\item{...}{Additional parameters.}
}
\value{
A Monte Carlo sample of uncertain input of a class of distribution
parameters.
}
\description{
Function that runs Monte Carlo simulations for MarginalScalar class objects.
}
\details{
\strong{"stratifiedSampling"} Number of samples (n) must be dividable by the
number of quantiles to assure each quantile is evenly represented.
}
\examples{

set.seed(12345)
# Example 1
scalarUM <- defineUM(uncertain = TRUE, distribution = "norm", distr_param = c(10, 1))
scalar_sample <- genSample(scalarUM, n = 10, samplemethod = "randomSampling")

# Example 2
scalarUM <- defineUM(uncertain = TRUE, distribution = "beta", distr_param = c(10, 1, 2))
scalar_sample <- genSample(scalarUM, n = 10, samplemethod = "stratifiedSampling", p = 0:5/5)

}
\author{
Kasia Sawicka
}

