% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_betas_spsur.R
\name{lr_betas_spsur}
\alias{lr_betas_spsur}
\title{Likelihood ratio for testing homogeneity constraints on beta coefficients of the SUR equations.}
\usage{
lr_betas_spsur(Form = NULL, data = NULL, R = NULL, b = NULL,
  W = NULL, time = NULL, X = NULL, Y = NULL, G = NULL,
  N = NULL, Tm = NULL, p = NULL, type = "sim",
  printmodels = FALSE, cov = FALSE, trace = FALSE)
}
\arguments{
\item{Form}{An object created with the package \code{\link[Formula]{Formula}}
that describes the model to be estimated. This model may contain several
responses (explained variables) and a varying number of regressors in each equation.}

\item{data}{An object of class data.frame or a matrix.}

\item{R}{A row vector of order \emph{(1xpr)} with  the set of \emph{r} linear constraints
on the \emph{beta} parameters. The \emph{first} restriction appears in the first \emph{p} terms,
the second restriction in the next \emph{p} terms and so on. Default = \code{NULL}.}

\item{b}{A column vector of order \emph{(rx1)} with the values of the linear restrictions on the
\emph{beta} parameters. Default = \code{NULL}.}

\item{W}{A spatial weighting matrix of order \emph{(NxN)}, assumed to be the
same for all equations and time periods.}

\item{time}{Time variable.}

\item{X}{A data matrix of order \emph{(NTmGxp)} with the observations of the regressors
The number of covariates in the SUR model is p = \eqn{sum(p_{g})} where \emph{\eqn{p_{g}}}
is the number of regressors (including the intercept) in the g-th equation, \emph{g = 1,...,G}).
The specification of \emph{X} is only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame. Default = \code{NULL}.}

\item{Y}{A column vector of order \emph{(NTmGx1)}, with the observations of the
explained variables. The ordering of the data must be (first) equation,
(second) time dimension and (third) Cross-sectional/spatial units.
The specification of \emph{Y} is only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame. Default = \code{NULL}.}

\item{G}{Number of equations.}

\item{N}{Number of cross-section or spatial units}

\item{Tm}{Number of time periods.}

\item{p}{Number of regressors by equation, including the intercept. \emph{p} can be a row
vector of order \emph{(1xG)}, if the number of regressors is not the same for all the
equations, or a scalar, if the \emph{G} equations have the same number of regressors.
The specification of \emph{p} is only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame.}

\item{type}{Type of spatial model specification: \strong{"sim"},\strong{"slx"}, \strong{"slm"},
\strong{"sem"}, \strong{"sdm"}, \strong{"sdem"} or \strong{"sarar"}. Default = \code{"sim"}.}

\item{printmodels}{Logical value: prints constrained and unconstrained models. Default = \code{FALSE}.
models. Default = \code{FALSE}.}

\item{cov}{Logical value to show the covariance matrix of the \emph{beta} coefficients.
Default = \code{TRUE}.}

\item{trace}{Logical value to show intermediate results during estimation. Default = \code{FALSE}.}
}
\value{
The function estimates two variants of the same SUR model, namely, a restricted and a unrestricted
 version. The purpose, as indicated above, is testing homogeneity constraints between the
 \eqn{\beta} parameters of the different equations of the SUR.
 The output of \code{\link{lr_betas_spsur}} shows, in first place, the iteration sequence of the
 maximum-likelihood algorithm. Then appears the Likelihood  Ratio, LR, test.
 The output also includes the maximum-likelihood estimation of the two models.

  \tabular{ll}{
  \code{statistic} \tab The Values of the LR test. \cr
  \code{p_val}    \tab The p-value of the LR test. \cr
  \code{df}    \tab Degrees of freedom. \cr
  \code{llik_unr}    \tab The Log-likelihood of the unrestricted model. \cr
  \code{llik_res} \tab The Log-likelihood of the restricted model. \cr
  }
}
\description{
Function \code{\link{lr_betas_spsur}} obtains a Likelihood Ratio test, LR in what follows,
  with the purpose of testing if some of the \eqn{\beta} coefficients in the \emph{G} equations of the
  \emph{SUR} model are equal. This function has a straightforward application, especially when \eqn{G=1},
  to the case of testing for the existence of structural breaks in the \eqn{\beta} parameters.

  The function can test for the homogeneity of only one coefficient, of a few of them
  or even the homogeneity of all the slope terms. The testing procedure implies, \emph{first},
  the estimation of both a constrained and a unconstrained model and, \emph{second}, the comparison
  of the log-likelihoods to compute the LR statistics.
}
\examples{
#################################################
######## CROSS SECTION DATA (G>1; Tm=1) ########
#################################################

#### Example 1: Spatial Phillips-Curve. Anselin (1988, p. 203)
rm(list = ls()) # Clean memory
data(spc)
Tformula <- WAGE83 | WAGE81 ~ UN83 + NMR83 + SMSA | UN80 + NMR80 + SMSA
## H0: equal beta for SMSA in both equations.
R <- matrix(c(0,0,0,1,0,0,0,-1),nrow=1)
b <- matrix(0,ncol=1)
LR_SMSA <-  lr_betas_spsur(Form = Tformula, data = spc, W = Wspc,
                           type = "sim", R = R, b = b, trace = TRUE,
                           printmodels = TRUE)

}
\references{
\itemize{
    \item Mur, J., López, F., and Herrera, M. (2010). Testing for spatial
      effects in seemingly unrelated regressions.
      \emph{Spatial Economic Analysis}, 5(4), 399-440.
  }
}
\seealso{
\code{\link{spsurml}}, \code{\link{spsurtime}}, \code{\link{wald_betas}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Jesús Mur  \tab \email{jmur@unizar.es} \cr
  }
}
