% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_uniquefy.R
\name{strUniquefy}
\alias{strUniquefy}
\title{Uniquefy a character vector}
\usage{
strUniquefy(x, sep_b = "_", sep_a = "", mark_first = TRUE)
}
\arguments{
\item{x}{character vector}

\item{sep_b}{string, separator before the number index}

\item{sep_a}{string, separator after the number index}

\item{mark_first}{bool, if duplicated values are found, do you want to add the
numeric index starting from the first copy? \code{FALSE} means starting from the second
copy.}
}
\value{
returns a character vector
}
\description{
Fix duplicated values in a character vector, useful in column names
and some ID structures that requires unique identifiers. If any duplicated string
is found in the vector, a numeric index will be added after the these strings.
}
\details{
The input can also be a numeric vector, but the return will always be character.
}
\examples{
strUniquefy(c(1,1,1,2,3))
strUniquefy(c(1,1,1,2,3), mark_first = FALSE)
strUniquefy(c(1,1,1,2,3), sep_b = "(", sep_a = ")")
strUniquefy(c("a","b","c","a","d","b"))
}
