% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{gallery}
\alias{gallery}
\title{A shiny gallery component}
\usage{
gallery(
  texts,
  hrefs,
  images,
  Id = NULL,
  title = "Gallery",
  title_color = "#0275d8",
  image_frame_size = 4,
  enlarge = FALSE,
  enlarge_method = c("inline", "modal"),
  style = ""
)
}
\arguments{
\item{texts}{vector of labels under each image}

\item{hrefs}{vector of links when each image is clicked}

\item{images}{a vector of image sources, can be online urls or local resource paths.}

\item{Id}{ID of this gallery}

\item{title}{Title of gallery}

\item{title_color}{Title color}

\item{image_frame_size}{integer, 1-12, this controls width. How large is each
image. 12 is the whole width of the screen and 1 is 1/12 of the screen. Consider
numbers than can fully divide 12, like 1, 2, 3, 4, 6 or 12 (if you want only 1 image
per row).}

\item{enlarge}{bool,  when click on the image, enlarge
it? If enlarge is enabled, click the photo will enlarge intead of jump to the link.
Only the title below contains the link if enlarge is enabled.}

\item{enlarge_method}{how the photo is enlarged on click,
one of "inline" -- within the gallery change the size of photo to 12, "modal" --
display photo in a pop-up modal.}

\item{style}{additional CSS style you want to add to the most outside component "div"}
}
\value{
a gallery component
}
\description{
Create a gallery to display images or photos

\code{texts}, \code{hrefs}, \code{images} Must have the same length

If there is any image that you do not want to add links, use \code{""} to occupy the space, e.g

\code{hrefs = c("https://xxx.com", "", "https://xxx.com")}

If the link is empty, there will be no hover effect on that image, and you cannot click it.

Similar to \code{hrefs}, for the \code{texts}, use \code{""} to  occupy space
}
\examples{
if(interactive()){
  texts <- c("p1", "p2", "", "p4", "p5")
  hrefs <- c("https://github.com/lz100/spsComps/blob/master/img/1.jpg?raw=true",
             "https://github.com/lz100/spsComps/blob/master/img/2.jpg?raw=true",
             "",
             "https://github.com/lz100/spsComps/blob/master/img/4.jpg?raw=true",
             "https://github.com/lz100/spsComps/blob/master/img/5.jpg?raw=true")
  images <- c("https://github.com/lz100/spsComps/blob/master/img/1.jpg?raw=true",
              "https://github.com/lz100/spsComps/blob/master/img/2.jpg?raw=true",
              "https://github.com/lz100/spsComps/blob/master/img/3.jpg?raw=true",
              "https://github.com/lz100/spsComps/blob/master/img/4.jpg?raw=true",
              "https://github.com/lz100/spsComps/blob/master/img/5.jpg?raw=true")
  library(shiny)

  ui <- fluidPage(
    column(
      6,
      gallery(texts = texts, hrefs = hrefs, images = images, title = "Default gallery"),
      spsHr(),
      gallery(texts = texts, hrefs = hrefs, images = images,
              image_frame_size = 2, title = "Photo size"),
      spsHr(),
      gallery(texts = texts, hrefs = hrefs, images = images,
              enlarge = TRUE, title = "Inline enlarge"),
      spsHr(),
      gallery(
        texts = texts, hrefs = hrefs, images = images,
        enlarge = TRUE, title = "Modal enlarge",
        enlarge_method = "modal"
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
