% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap_canonical2.R
\name{remap_canonical2}
\alias{remap_canonical2}
\title{Canonical re-mapping of mixture component labels}
\usage{
remap_canonical2(z)
}
\arguments{
\item{z}{A length-n vector of discrete mixture component labels}
}
\value{
A length-n vector of mixture component labels re-mapped to a canonical sub-space
}
\description{
Avoid label switching by re-mapping sampled mixture component labels at each iteration (Peng and Carvhalo 2016).
}
\examples{
# parameters
n <- 10 # number of observations
K <- 3 # number of clusters (mixture components)
pi <- rep(1/K,K) # cluster membership probability
z <- sample(1:K, size = n, replace = TRUE, prob = pi) # cluster indicators
z <- remap_canonical2(z)
}
