% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.to.species.freq.R
\name{sample.to.species.freq}
\alias{sample.to.species.freq}
\title{Create Vector of Species Frequencies}
\usage{
sample.to.species.freq(x, min.f = NULL)
}
\arguments{
\item{x}{a vector where \code{x[i]} is of the number of samples in the 
\code{i}-th species.}

\item{min.f}{minimum size of return vector. Return vector is zero-padded up 
to this length if it would normally be shorter.}
}
\value{
a vector(\code{f}) of species frequencies where \code{f[i]} is the 
  number of species represented by only \code{i} samples.
}
\description{
Create vector of species frequencies from vector of sample 
  frequencies.
}
\examples{
x <- sample(1:20, 20, rep = TRUE)
f <- sample.to.species.freq(x)
print(x)
print(f)

}
\seealso{
species.to.sample.freq
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
