% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shows.R
\name{get_show}
\alias{get_show}
\title{Get Spotify catalog information for a single show.}
\usage{
get_show(id, market = NULL, authorization = get_spotify_authorization_code())
}
\arguments{
\item{id}{The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the show.}

\item{market}{Optional. \cr
An \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code} or the string \code{"from_token"}.
If a country code is specified, only shows and episodes that are available in that market will be returned.
If a valid user access token is specified in the request header, the country associated with the user account will take priority over this
parameter.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. \cr
Reading the user’s resume points on episode objects requires the user-read-playback-position scope. See \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}
}
\value{
Returns a data frame of results containing show data.
See the \href{https://developer.spotify.com/documentation/web-api/reference/shows/get-a-show/}{official documentation} for more information.
}
\description{
Get Spotify catalog information for a single show.
}
