% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{seek_to_position}
\alias{seek_to_position}
\title{Seeks to the given position in the user’s currently playing track.}
\usage{
seek_to_position(position_ms, device_id = NULL,
  authorization = get_spotify_authorization_code())
}
\arguments{
\item{position_ms}{Required. Integer indicating the position in milliseconds to seek to. Must be a positive number. Passing in a position that is greater than the length of the track will cause the player to start playing the next song.}

\item{device_id}{Optional. The id of the device this command is targeting. If not supplied, the user’s currently active device is the target.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}. The access token must have been issued on behalf of the current user. \cr
The access token must have the \code{user-modify-playback-state} scope authorized in order to control playback.}
}
\description{
Seeks to the given position in the user’s currently playing track.
}
