% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.R
\name{influence.spmod}
\alias{influence.spmod}
\title{Regression diagnostics}
\usage{
\method{influence}{spmod}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tibble with residuals (\code{.resid}), leverage values (\code{.hat}),
cook's distance (\code{.cooksd}), and standardized residuals (\code{.std.resid}).
}
\description{
Provides basic quantities which are used in forming
a wide variety of diagnostics for checking the quality of fitted model objects.
}
\details{
This function calls \code{\link[=residuals.spmod]{residuals.spmod()}}, \code{\link[=hatvalues.spmod]{hatvalues.spmod()}},
and \code{\link[=cooks.distance.spmod]{cooks.distance.spmod()}} and puts the results into a tibble. It is
primarily used when calling \code{\link[=augment.spmod]{augment.spmod()}}.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
influence(spmod)
}
\seealso{
\code{\link[=augment.spmod]{augment.spmod()}} \code{\link[=cooks.distance.spmod]{cooks.distance.spmod()}} \code{\link[=hatvalues.spmod]{hatvalues.spmod()}} \code{\link[=residuals.spmod]{residuals.spmod()}}
}
