% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnetcv.R
\name{glmnetcv}
\alias{glmnetcv}
\title{Cross validation, n-fold and leave-one-out, for 'glmnet' in 'glmnet' package}
\usage{
glmnetcv(
  trainx,
  y,
  family = "gaussian",
  alpha = 0.5,
  relax = FALSE,
  type.measure = "mse",
  validation = "CV",
  cv.fold = 10,
  predacc = "VEcv",
  ...
)
}
\arguments{
\item{trainx}{a matrix contains predictive variables of point samples.
The location information, longitude (long), latitude (lat), need to be included
in the 'trainx' for spatial predictive modelling.}

\item{y}{a vector of the response variable in the formula, that is, the left
part of the formula.}

\item{family}{a description of the error distribution and link function to
be used in the model. See '?glmnet' for details.}

\item{alpha, }{an elasticnet mixing parameter, with $0 <= alpha <= 1$.
See '?glmnet' for details.}

\item{relax, }{if TRUE then for each active set in the path of solutions,
the model is refit without any regularization. See '?glmnet' for more information.}

\item{type.measure, }{loss to use for cross-validation. The default is
type.measure="mse". See '?cv.glmnet' for more information.}

\item{validation}{validation methods, include 'LOO': leave-one-out, and 'CV':
cross-validation.}

\item{cv.fold}{integer; number of folds in the cross-validation. if > 1,
then apply n-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}

\item{predacc}{can be either "VEcv" for vecv or "ALL" for all measures
in function pred.acc.}

\item{...}{other arguments passed on to 'fields'.}
}
\value{
A list with the following components:
 me, rme, mae, rmae, mse, rmse, rrmse, vecv and e1; or vecv only
}
\description{
This function is a cross validation function
for 'glmnet' method in 'glmnet' package.
}
\note{
This function is largely based on 'glmcv' in this 'spm2' package.
}
\examples{
\donttest{
library(spm)

data(petrel)
x <- as.matrix(petrel[, c(1, 2, 6:9)])
y <- log(petrel[, 5] + 1)
set.seed(1234)
glmnetcv1 <- glmnetcv(x, y, validation = "CV",  predacc = "ALL")
glmnetcv1

data(sponge)
x <- as.matrix(cbind(sponge$easting, sponge$easting^2))
set.seed(1234)
glmnetcv1 <- glmnetcv(x, sponge[, 3], family = poisson, validation = "CV",
predacc = "ALL")
glmnetcv1

# For glmnet with gaussian
x <- as.matrix(petrel[, c(1, 2, 6:9)])
y <- log(petrel[, 5] + 1)
set.seed(1234)
n <- 20 # number of iterations,60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
  glmnetcv1 <- glmnetcv(x, y, validation = "CV", predacc = "VEcv")
  VEcv [i] <- glmnetcv1
 }
plot(VEcv ~ c(1:n), xlab = "Iteration for glmnet", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)

# For glmnet with binomial
x <- as.matrix(cbind(petrel[, c(2, 6)], petrel$long^3, petrel$lat^2, petrel$lat^3))
set.seed(1234)
n <- 20 # number of iterations,60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
glmnetcv1 <- glmnetcv(x, petrel[, 5] / 100, family = binomial(link=logit),
validation = "CV", predacc = "VEcv")
VEcv [i] <- glmnetcv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for glmnet", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)
}

}
\references{
A. Liaw and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.
}
\author{
Jin Li
}
