% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmkrigeidwpred.R
\name{glmkrigeidwpred}
\alias{glmkrigeidwpred}
\title{Generate spatial predictions using the hybrid methods of
generalised linear models  ('glm'), 'kriging' and inverse distance weighted ('IDW').}
\usage{
glmkrigeidwpred(
  formula.glm = NULL,
  longlat,
  trainxy,
  predx,
  y,
  longlatpredx,
  family = "gaussian",
  transformation = "none",
  delta = 1,
  formula.krige = res1 ~ 1,
  vgm.args = c("Sph"),
  anis = c(0, 1),
  alpha = 0,
  block = 0,
  beta,
  nmaxkrige = 12,
  idp = 2,
  nmaxidw = 12,
  hybrid.parameter = 2,
  lambda = 1,
  ...
)
}
\arguments{
\item{formula.glm}{a formula defining the response variable and predictive variables for 'glm'.}

\item{longlat}{a dataframe contains longitude and latitude of point samples.}

\item{trainxy}{a dataframe contains longitude (long), latitude (lat),
predictive variables and the response variable of point samples.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{y}{a vector of the response variable in the formula, that is, the left
part of the formula.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centers of grids) to be predicted.}

\item{family}{a description of the error distribution and link function to
be used in the model. See '?glm' for details.}

\item{transformation}{transform the residuals of 'glm' to normalise the data;
can be "sqrt" for square root, "arcsine" for arcsine, "log" or "none"
for non transformation. By default, "none" is used.}

\item{delta}{numeric; to avoid log(0) in the log transformation. The default is 1.}

\item{formula.krige}{formula defining the response vector and (possible) regressor.
an object (i.e., 'variogram.formula') for 'variogram' or a formula for
'krige'. see 'variogram' and 'krige' in 'gstat' for details.}

\item{vgm.args}{arguments for 'vgm', e.g. variogram model of response
variable and anisotropy parameters. see 'vgm' in 'gstat' for details.
By default, "Sph" is used.}

\item{anis}{anisotropy parameters: see notes 'vgm' in 'gstat' for details.}

\item{alpha}{direction in plane (x,y). see variogram in 'gstat' for details.}

\item{block}{block size. see 'krige' in 'gstat' for details.}

\item{beta}{for simple kriging. see 'krige' in 'gstat' for details.}

\item{nmaxkrige}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is defined in
terms of the space of the spatial locations. By default, 12 observations
are used.}

\item{idp}{a numeric number specifying the inverse distance weighting power.}

\item{nmaxidw}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is defined in
terms of the space of the spatial locations. By default, 12 observations
are used.}

\item{hybrid.parameter}{the default is 2 that is for 'glmkrigeglmidw';
for 'glmglmkrigeglmidw', it needs to be 3.}

\item{lambda, }{ranging from 0 to 2; the default is 1 for 'glmkrigeglmidw'
and 'glmglmkrigeglmidw'; and if it is < 1, more weight is placed on 'krige',
otherwise more weight is placed on 'idw'; and if it is 0, 'idw' is not
considered and the resultant methods is 'glmkrige' when the default
'hybrid.parameter' is used; and if it is 2, then the resultant method is
'glmidw' when the default 'hybrid.parameter' is used.}

\item{...}{other arguments passed on to 'glm', 'krige' and 'gstat'.}
}
\value{
A dataframe of longitude, latitude, and predictions.
}
\description{
This function is for generating spatial predictions using the
hybrid methods of 'glm', 'kriging' and 'IDW', including all methods implemented
in 'glmkrigeidwcv'.
}
\examples{
\donttest{
library(spm)

data(petrel)
data(petrel.grid)

gravel <- petrel[, c(1, 2, 6:9, 5)]
longlat <- petrel[, c(1, 2)]
model <- log(gravel + 1) ~  lat +  bathy + I(long^3) + I(lat^2) + I(lat^3)
y <- log(gravel[, 7] +1)

glmkrigeidwpred1 <- glmkrigeidwpred(formula.glm = model, longlat = longlat, trainxy =  gravel,
predx = petrel.grid, y = y, longlatpredx = petrel.grid[, c(1:2)],
formula.krige = res1 ~ 1, vgm.args = "Sph", nmaxkrige = 12, idp = 2, nmaxidw = 12)
 # Since the default 'family' is used, actually a 'lm' model is used.

names(glmkrigeidwpred1)

# Back transform 'glmkrigeidwpred$predictions' to generate the final predictions
glmkrigeidw.predictions <- exp(glmkrigeidwpred1$predictions) - 1
range(glmkrigeidw.predictions)
}

}
\references{
Li, J., Alvarez, B., Siwabessy, J., Tran, M., Huang, Z.,
Przeslawski, R., Radke, L., Howard, F. and Nichol, S. (2017). "Application
of random forest, generalised linear model and their hybrid methods with
geostatistical techniques to count data: Predicting sponge species richness."
Environmental Modelling & Software 97: 112-129.

Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat package.
Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
