% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgokpred.R
\name{rgokpred}
\alias{rgokpred}
\title{Generate spatial predictions using the hybrid method of random forest in
ranger and ordinary kriging (RGOK)}
\usage{
rgokpred(longlat, trainx, trainy, longlatpredx, predx, mtry = function(p)
  max(1, floor(sqrt(p))), num.trees = 500, min.node.size = NULL,
  type = "response", num.threads = NULL, verbose = FALSE, nmax = 12,
  vgm.args = ("Sph"), block = 0, ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of validation
samples.}

\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centres of grids) to be predicted.}

\item{predx}{a dataframe or matrix contains columns of predictive variables for
the grids to be predicted.}

\item{mtry}{a function of number of remaining predictor variables to use as
the mtry parameter in the randomForest call.}

\item{num.trees}{number of trees. By default, 500 is used.}

\item{min.node.size}{Default 1 for classification, 5 for regression.}

\item{type}{Type of prediction. One of 'response', 'se', 'terminalNodes' with
default 'response'. See ranger::predict.ranger for details.}

\item{num.threads}{number of threads. Default is number of CPUs available.}

\item{verbose}{Show computation status and estimated runtime.Default is FALSE.}

\item{nmax}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{block}{block size. see krige in gstat for details.}

\item{...}{other arguments passed on to randomForest or gstat.}
}
\value{
A dataframe of longitude, latitude, predictions and variances. The
variances are produced by OK based on the residuals of rf.
}
\description{
This function is to make spatial predictions using the hybrid
method of random forest in ranger and ordinary kriging (RGOK).
}
\note{
This function is largely based rfokpred.  When 'A zero or
negative range was fitted to variogram' occurs, to allow OK running, the
range was set to be positive by using min(vgm1$dist). In this case, caution
should be taken in applying this method, although sometimes it can still
outperform IDW and OK.
}
\examples{
\dontrun{
data(petrel)
data(petrel.grid)
rgokpred1 <- rgokpred(petrel[, c(1,2)], petrel[, c(1,2, 6:9)], petrel[, 3],
petrel.grid[, c(1,2)], petrel.grid, num.trees = 500, nmax = 12, vgm.args =
("Sph"))
names(rgokpred1)
}

}
\references{
Wright, M. N. & Ziegler, A. (2017). ranger: A Fast Implementation
of Random Forests for High Dimensional Data in C++ and R. J Stat Softw 77:1-17.
http://dx.doi.org/10.18637/jss.v077.i01.
}
\author{
Jin Li
}
