%%  WARNING: This file was automatically generated from the associated 
%%  Swrappers.mid file. Do NOT edit this Rd file to make a change. Instead, 
%%  edit the Swrappers.mid file in the project MID directory. Once the 
%%  Swrappers.mid file has been updated, this Rd file, and all other 
%%  documentation (such as corresponding LaTeX, SGML and HTML documentation) 
%%  should be regenerated using the mid.pl Perl script. 

%% R documentation for the is.numeric.atomic.vector function

\name{is.numeric.atomic.vector}
\alias{is.numeric.atomic.vector}
\title{Tests whether an object is a vector or not}
\concept{utilities}
\usage{is.numeric.atomic.vector(x)}
\description{The \code{is.vector} function returns a \code{FALSE}
value in some cases where intuitively one might
expect a \code{TRUE} value to be returned. For example,
\code{is.vector(z)} returns \code{FALSE} for each of the
following:
\describe{
\item{i}{\code{z <- 1:3;names(z) <- 1:3}}

\item{ii}{\code{z <- matrix(1:3, nrow=1)}}

\item{iii}{\code{z <- matrix(1:3, ncol=1)}}}

These results are not necessarily incorrect, they are
just one interpretion of the definition of a vector.
Contrarily, the \code{is.numeric.atomic.vector(z)} function returns
\code{TRUE} for each of the above examples. Thus,
\code{is.numeric.atomic.vector} expands the basic definition of a
vector to allow matrices containing a single row
or column and named vectors. Also, unlike \code{is.vector},
\code{is.numeric.atomic.vector} returns \code{FALSE} for objects of class \code{list}.}

\arguments{
\item{x}{an object of arbitrary class.}

}

\value{
a vector of character strings containing the result. The length
of this vector is equal to \code{length(x)}.
}
\seealso{
\code{\link{anyMissing}},
\code{\link{as.rectangular}},
\code{\link{colIds}},
\code{\link{colMaxs}},
\code{\link{colMedians}},
\code{\link{colMins}},
\code{\link{colRanges}},
\code{\link{colStdevs}},
\code{\link{colVars}},
\code{\link{deparseText}},
\code{\link{ifelse1}},
\code{\link{is.missing}},
\code{\link{is.rectangular}},
\code{\link{is.zero}},
\code{\link{lowerCase}},
\code{\link{oldUnclass}},
\code{\link{numCols}},
\code{\link{numRows}},
\code{\link{peaks}},
\code{\link{positions}},
\code{\link{rowIds}},
\code{\link{rowMaxs}},
\code{\link{rmvnorm}},
\code{\link{stdev}},
\code{\link{subscript2d}},
\code{\link{upperCase}},
\code{\link{vecnorm}},
\code{\link{which.na}}.
}

\examples{
## cases where is.numeric.atomic.vector returns 
## TRUE 
z <- 1:3;names(z) <- letters[1:3]
is.numeric.atomic.vector(z)
is.numeric.atomic.vector(matrix(1:3, nrow=1))
is.numeric.atomic.vector(matrix(1:3, ncol=1))
is.numeric.atomic.vector(1:5)
is.numeric.atomic.vector(letters)

## cases where is.numeric.atomic.vector returns 
## FALSE 
is.numeric.atomic.vector(list(1:3))
is.numeric.atomic.vector(data.frame(1:3,2:4))
is.numeric.atomic.vector(matrix(1:12, nrow=4))
}
\keyword{utilities}

