% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{sdregi}
\alias{sdregi}
\title{SD ratio of equalities or greater inequalities}
\usage{
sdregi(x, y)
}
\arguments{
\item{x}{(vector) a numeric vector}

\item{y}{(vector) a numeric vector with compatible dimensions to x}
}
\value{
(numeric) SD ratio
}
\description{
Returns the ratio of the SDs of \code{x} and \code{y}, using the largest
SD of the two as denominator. Hence, the result is always 1 (ratio of
equalities) or greater than 1 (ratio of greater inequalities).
If x or y have less than two elements, NA is returned.
}
\examples{
# Generate two variables with different means, variances and a correlation of about 0.5
library(MASS)
vars = mvrnorm(30, mu = c(0, 2), Sigma = matrix(c(5, 2, 2, 3), ncol = 2), empirical = TRUE)
# Calculate SD ratio of left and right variables
sdregi(vars[,1], vars[,2])
# Calculate SD ratio of right and left variables; should give same result
sdregi(vars[,1], vars[,2])
}
\seealso{
Other splithalfr coefficients: 
\code{\link{angoff_feldt}()},
\code{\link{assmd}()},
\code{\link{flanagan_rulon}()},
\code{\link{short_icc}()},
\code{\link{spearman_brown}()}
}
\concept{splithalfr coefficients}
