% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsplit.R
\name{nsplit}
\alias{nsplit}
\title{Compute Total Number of Possible Splits}
\usage{
nsplit(p, G, use.all = TRUE, fix.partition = NULL)
}
\arguments{
\item{p}{Number of variables or objects to split.}

\item{G}{Number of groups into which the variables are split.}

\item{use.all}{Boolean variable to determine if all variables must be used (default is TRUE).}

\item{fix.partition}{Optional matrix with G columns (or list if more than one value of G) indicating the partitions (in each row) to be considered for the splits.}
}
\value{
A numeric vector with the total number of possible splits.
}
\description{
\code{nsplits} returns the total number of possible splits of variables into groups.
}
\examples{
# Compute the total number of possible splits of 6 variables into 3 groups
# We use all the variables
out.n.splits.all <- nsplit(p=6, G=3, use.all=TRUE)
out.n.splits.all
# We don't enforce using all the variables
out.n.splits <- nsplit(p=6, G=3, use.all=FALSE)
out.n.splits

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
