% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_rpart_fns.R
\name{spline_init}
\alias{spline_init}
\title{Custom rpart init function}
\usage{
spline_init(y, offset = NULL, parms = NULL, wt = NULL)
}
\arguments{
\item{y}{Response data, which will be estimated spline coefficients}

\item{offset}{Required by rpart, but never used by splinetree, so its value will always be NULL}

\item{parms}{rpart's custom split functionality allows optional parameters to be passed through the
splitting functions. In the splinetree package, the parms parameter is used to hold a list of length
1 or 2 containing a spline basis matrix and the probability that a variable will be selected at a split.
The probability is only used in splineforests. For splinetrees, only the basis matrix is needed.}

\item{wt}{Used to weight observations differently. Required by rpart, but not supported by splinetree, so its value will always be NULL.}
}
\value{
A list of information for this node that is used internally by rpart.
}
\description{
The init function is required for custom rpart functionality. This function initializes every node. The init function is responsible for defining the summary function
that will be used by rpart's summary function if you call summary() on this tree object. The init function also passes forward its arguments and tells rpart
the dimension of the response variable. This function is called internally by rpart; the details are not important for the end user.
}
\keyword{internal}
