% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar.R
\name{berger_tls}
\alias{berger_tls}
\title{Calculate true anomaly and true longitude}
\usage{
berger_tls(n, N, ke = 0.0167, keps = 23.44, komega = 283, pir = pi/180)
}
\arguments{
\item{n}{Numeric, day of year.}

\item{N}{Numeric, days in a year.}

\item{ke}{double, eccentricity of earth's orbit.
Default: \eqn{0.01670}, 2000CE (Berger, 1978).}

\item{keps}{double, obliquity of earth's elliptic.
Default: \eqn{23.44}, 2000CE (Berger, 1978).}

\item{komega}{double, lon. of perihelion, degrees
Default: \eqn{283}, 2000CE (Berger, 1978).}

\item{pir}{\eqn{\pi} (\eqn{~ 0.017453}) in radians.}
}
\value{
True anomaly and true longitude for a given day.
}
\description{
Calculate true anomaly and true longitude
}
\references{
Berger, A.L., 1978. Long-term variations of daily insolation and Quaternary
climatic changes. Journal of Atmospheric Sciences, 35(12), pp.2362-2367.
\doi{10.1175/1520-0469(1978)035<2362:LTVODI>2.0.CO;2}
}
\keyword{internal}
