% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_origin}
\alias{proto_origin}
\alias{proto_origin2d}
\alias{proto_origin1d}
\title{Tour proto for data origin zero mark}
\usage{
proto_origin(
  identity_args = list(color = "grey60", size = 0.5, alpha = 0.9),
  tail_size = 0.05
)

proto_origin1d(identity_args = list(color = "grey60", size = 0.5, alpha = 0.9))
}
\arguments{
\item{identity_args}{A list of static, identity arguments passed into
\code{geom_point()}, but outside of \code{aes()}, for instance
\code{geom_point(aes(...), size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.}

\item{tail_size}{How long the origin mark should extended
relative to the observations. Defaults to .05, 5\% of the projection space.}
}
\description{
Adds a zero mark showing the location of the origin for the central data area.
}
\examples{
dat <- scale_sd(tourr::flea[, 1:6])
clas <- tourr::flea$species

## 2D case:
gt_path <- tourr::save_history(dat, grand_tour(), max_bases = 5)

ggt <- ggtour(gt_path, dat, angle = .1) +
  proto_origin() +
  proto_point()
\dontrun{
animate_plotly(ggt)}

## 1D case:
gt_path1d <- tourr::save_history(dat, grand_tour(d = 1), max_bases = 5)

ggt <- ggtour(gt_path1d, dat) +
  proto_origin1d() +
  proto_density(list(fill = clas, color = clas))
\dontrun{
animate_plotly(ggt)}
}
\seealso{
Other ggtour proto: 
\code{\link{filmstrip}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}

Other ggtour proto: 
\code{\link{filmstrip}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto}
