% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_spind.R
\name{step.spind}
\alias{step.spind}
\title{Stepwise model selection for GEEs and WRMs}
\usage{
step.spind(object, data, steps = NULL, trace = TRUE, AICc = FALSE)
}
\arguments{
\item{object}{A model of class \code{WRM} or \code{GEE}.}

\item{data}{The data used to fit that model.}

\item{steps}{Number of iterations the procedure should
go through before concluding. The default is to use the number of
variables as the number of iterations.}

\item{trace}{Should R print progress updates and the final, best model found
to the console? Default is \code{TRUE}.}

\item{AICc}{Logical. In the case of model selection with \code{WRM}s,
should AICc be used to determine which model is best rather than AIC?
This argument is ignored for \code{GEE}s. Default is \code{FALSE}.}
}
\value{
A list with components \code{model} and \code{table}.
\code{model} is always formula for the best model found by the procedure.
\code{table} is always a data frame, but the content varies for each type of
model.
For \code{WRM}'s, the columns
returned are
\itemize{
  \item\code{Deleted.Vars} Variables retained from the previous iteration
  which were tested in the current iteration.
  \item\code{LogLik} Log-likelihood of the model.
  \item\code{AIC} AIC score for the model.
  \item\code{AICc} AICc score for the model.
}

For \code{GEE}s:
\itemize{
  \item\code{Deleted.Vars} Variables retained from the previous iteration
  which were tested in the current iteration.
  \item\code{QIC} Quasi-information criterion of the model.
  \item\code{Quasi.Lik} Quasi-likelihood of the model.
}
}
\description{
Stepwise model selection by AIC or AICc for WRMS
and QIC for GEEs
}
\details{
This function performs stepwise variable elimination
for model comparison. Each iteration will try to find the best
combination of predictors for a given number of variables based
on AIC, AICc, or QIC, and then use that as the base model
for the next iteration until there are no more variables to eliminate.
Alternatively, it will terminate when reducing the number of variables
while respecting the model hierarchy no longer produces lower
information criterion values.
}
\note{
Currently, the function only supports backwards model selection
(i.e. one must start with a full model and subtract variables).
Forward and both directions options may be added later.
}
\examples{
# For demonstration only. We are artificially imposing a grid structure
# on data that is not actually spatial data
library(MASS)
data(birthwt)


x<-rep(1:14,14)
y<-as.integer(gl(14,14))
coords<-cbind(x[-(190:196)],y[-(190:196)])
\dontrun{
formula<-formula(low ~ age+ lwt+ race+ smoke+ ftv+  bwt)

mgee<-GEE(formula, family = "gaussian", data = birthwt,
          coord=coords, corstr="fixed",scale.fix=TRUE)

ss<-step.spind(mgee,birthwt)

best.mgee<-GEE(ss$model, family = "gaussian", data = birthwt,
           coord=coords, corstr="fixed",scale.fix=TRUE)

summary(best.mgee,printAutoCorPars=FALSE)
}

}
\references{
Hardin, J.W. & Hilbe, J.M. (2003) Generalized Estimating Equations. Chapman and Hall, New York.
}
\seealso{
\code{\link{qic.calc}}, \code{\link{aic.calc}}, \code{\link[stats]{add1}},
\code{\link[stats]{step}}, \code{\link[MASS]{stepAIC}}
}
\author{
Sam Levin
}
