% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavevar.R
\name{wavevar}
\alias{wavevar}
\title{Wavelet variance analysis}
\usage{
wavevar(f, coord, wavelet = "haar", wtrafo = "dwt")
}
\arguments{
\item{f}{A vector}

\item{coord}{A matrix of two columns with corresponding cartesian
coordinates. Currently only supports integer coordinates.}

\item{wavelet}{Name of wavelet family. \code{haar}, \code{d4}, and \code{la8}.
are possible. \code{haar} is the default.}

\item{wtrafo}{Type of wavelet transform. Either \code{dwt} or \code{modwt}.
\code{dwt} is the default.}
}
\value{
Wavelet variance for \code{f}.
}
\description{
Calculates the wavelet variance based on a wavelet
multiresolution analysis.
}
\examples{
data(carlinadata)
coords <- carlinadata[ ,4:5]
pc <- covar.plot(carlina.horrida ~ aridity + land.use, carlinadata, coords,
                 wavelet = 'd4', wtrafo = 'modwt', plot = 'covar')
}
\seealso{
\pkg{waveslim}, \code{\link{WRM}}, \code{\link{covar.plot}},
 \code{\link{scaleWMRR}}
}
\author{
Gudrun Carl
}
