% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slideNucDiag.R
\name{slideNucDiag}
\alias{slideNucDiag}
\title{Sliding nucleotide diagnostics}
\usage{
slideNucDiag(DNAbin, sppVector, width, interval = 1)
}
\arguments{
\item{DNAbin}{A DNA alignment of class `DNAbin'.}

\item{sppVector}{Species vector (see \code{\link{sppVector}}).}

\item{width}{Desired width of windows in number of base pairs.}

\item{interval}{Distance between each window in number of base pairs.
Default of 1. Giving the option of \code{"codons"} sets the size to 3.}
}
\value{
A matrix giving the number of diagnostic nucleotides for each
species (rows) in each window (columns).
}
\description{
Calculates the number of diagnostic nucleotides in sliding windows.
}
\details{
Determines the number of diagnostic nucleotides for each species in each
window.
}
\examples{

data(dolomedes)
doloSpp <- substr(dimnames(dolomedes)[[1]], 1, 5)

slideNucDiag(dolomedes, doloSpp, 200, interval = 3)

slidND <- slideNucDiag(dolomedes, doloSpp, 200, interval = 3)

#Number of basepairs for each species
graphics::matplot(t(slidND), type = "l")

#Number of basepairs for a single species
graphics::plot(slidND[4, ], type = "l")

#Total number of basepairs per window
graphics::plot(colSums(slidND), type = "l")


}
\seealso{
\code{\link{slideAnalyses}}, \code{\link{slideBoxplots}},
\code{\link{slidingWindow}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Sliding}
\keyword{window}
