% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cgraph}
\alias{cgraph}
\title{Complete graph}
\usage{
cgraph(x, y = NULL, ...)
}
\arguments{
\item{x}{X values, or a matrix with two columns containing X and Y values.}

\item{y}{Y values. Can be left empty if \code{x} is a matrix.}

\item{...}{Other arguments to be passed to \code{\link{segments}}.}
}
\value{
Plots a complete graph between the given vertices.
}
\description{
Creates a complete graph for the given cloud of vertices.
}
\details{
If \code{y} is not given, \code{x} is required to be a matrix containing
both x and y values.
}
\examples{

x <- runif(15)
y <- runif(15)

graphics::plot(x, y)
cgraph(x, y)

M <- cbind(x, y)
cgraph(M[1:10,], col = "blue")

}
\seealso{
\code{\link{plot.ordinDNA}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Visualisation}
