% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spex-package.R
\docType{package}
\name{spex-package}
\alias{spex-package}
\title{spex}
\description{
Tools for spatial extents that are agnostic regarding format (i.e. \code{sp},
\code{sf}, or \code{raster}). These functions fill some of the gaps within and between
these packages for dealing with object extents in flexible ways. Generally,
spex considers extents of raster cells, and extents of objects as first-class
objects (with projection metadata). and provides helpers for  latitudinal
boundaries within projected data.
}
\section{Spatial Extent}{

\tabular{ll}{
\code{\link{buffer_extent}} \tab Buffer an extent to a given whole number. \cr
\code{\link{latitudecircle}} \tab Create a latitude circle in a chosen projection. \cr
\code{\link{latmask}} \tab Mask a raster based on a minimum (or maximum) latitude. \cr
\code{\link{polygonize}} \tab Convert raster cells to polygons. \cr
\code{\link{qm_rasterToPolygons}} \tab The \code{sf} version of \code{polygonize}.  \cr
\code{\link{qm_rasterToPolygons_sp}} \tab The \code{sp} version of \code{polygonize}. \cr
\code{\link{spex}} \tab A function to produce a fully fledged Spatial object extent. \cr
\code{\link{xlim}, \link{ylim}} \tab Helper functions for extents. \cr

}
}

