/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AbstractTabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.LineTabsLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.MenuLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuLineLayout
extends AbstractTabLayoutManager<Layout> {
    @Override
    protected Layout createInfoFor(TabPane pane) {
        return new Layout(pane);
    }

    @Override
    protected void destroy(Layout info) {
        info.destroy();
    }

    @Override
    public Dimension getMinimumSize(TabPane pane) {
        Layout layout = (Layout)this.getInfo(pane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        return layout.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(TabPane pane) {
        Layout layout = (Layout)this.getInfo(pane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        return layout.getPreferredSize();
    }

    @Override
    public void layout(TabPane pane) {
        Layout layout = (Layout)this.getInfo(pane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        layout.layout();
    }

    protected Size[] getSizes(LayoutBlock block, Size.Type type) {
        if (block == null) {
            return new Size[0];
        }
        Size[] sizes = block.getSizes();
        if (sizes == null) {
            return new Size[0];
        }
        return this.getSizes(sizes, type);
    }

    protected Size[] getSizes(Size[] choices, Size.Type type) {
        int count = 0;
        for (Size size : choices) {
            if (size.getType() != type) continue;
            ++count;
        }
        Size[] result = new Size[count];
        int index = 0;
        for (Size size : choices) {
            if (size.getType() != type) continue;
            result[index++] = size;
        }
        return result;
    }

    protected AxisConversion getConversion(TabPane pane) {
        return new DefaultAxisConversion(pane.getAvailableArea(), pane.getTabPlacement());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Layout
    extends AbstractTabLayoutManager.PaneInfo {
        private MenuLayoutBlock menu;
        private LayoutBlock info;
        private LineTabsLayoutBlock tabs;

        public Layout(TabPane pane) {
            super(pane);
            this.menu = new MenuLayoutBlock();
            this.menu.setMenu(pane.createMenu());
            LonelyTabPaneComponent infoComponent = pane.getInfoComponent();
            if (infoComponent != null) {
                this.info = infoComponent.toLayoutBlock();
            }
            this.tabs = new LineTabsLayoutBlock();
            this.tabs.setPane(pane);
        }

        public Dimension getPreferredSize() {
            List<PaneLayout> layouts = this.listLayouts();
            Dimension bestSize = new Dimension(0, 0);
            if (this.getPane().getTabPlacement().isHorizontal()) {
                for (PaneLayout layout : layouts) {
                    if (!layout.isPreferred()) continue;
                    Dimension size = layout.getSize();
                    if (size.width <= bestSize.width) continue;
                    bestSize = size;
                }
            } else {
                for (PaneLayout layout : layouts) {
                    if (!layout.isPreferred()) continue;
                    Dimension size = layout.getSize();
                    if (size.height <= bestSize.height) continue;
                    bestSize = size;
                }
            }
            return bestSize;
        }

        public Dimension getMinimumSize() {
            List<PaneLayout> layouts = this.listLayouts();
            Dimension bestSize = null;
            if (this.getPane().getTabPlacement().isHorizontal()) {
                for (PaneLayout layout : layouts) {
                    Dimension size = layout.getSize();
                    if (bestSize != null && size.width >= bestSize.width) continue;
                    bestSize = size;
                }
            } else {
                for (PaneLayout layout : layouts) {
                    Dimension size = layout.getSize();
                    if (bestSize != null && size.height >= bestSize.height) continue;
                    bestSize = size;
                }
            }
            return bestSize;
        }

        public void destroy() {
            this.getPane().destroyMenu(this.menu.getMenu());
        }

        public void layout() {
            AxisConversion conversion = MenuLineLayout.this.getConversion(this.getPane());
            List<PaneLayout> layouts = this.listLayouts();
            Rectangle available = conversion.viewToModel(this.getPane().getAvailableArea());
            int space = available.width;
            PaneLayout best = null;
            int bestSize = -1;
            PaneLayout smallest = null;
            int smallestSize = -1;
            for (PaneLayout layout : layouts) {
                Dimension size = conversion.viewToModel(layout.getSize());
                if (size.width <= space) {
                    if (layout.isPreferred()) {
                        if (best == null || !best.isPreferred() || bestSize < size.width) {
                            bestSize = size.width;
                            best = layout;
                        }
                    } else if (best == null || !best.isPreferred() && bestSize < size.width) {
                        bestSize = size.width;
                        best = layout;
                    }
                }
                if (smallest != null && size.width >= smallestSize) continue;
                smallest = layout;
                smallestSize = size.width;
            }
            if (best != null) {
                best.apply();
            } else if (smallest != null) {
                smallest.apply();
            }
        }

        private List<PaneLayout> listLayouts() {
            ArrayList<PaneLayout> results = new ArrayList<PaneLayout>();
            TabPlacement orientation = this.getPane().getTabPlacement();
            this.tabs.setOrientation(orientation);
            LineTabsLayoutBlock.LineSize[] sizesTabs = this.tabs.getSizes();
            this.menu.setOrientation(orientation);
            Size[] sizesMenu = this.menu.getSizes();
            if (this.info != null) {
                Size[] sizesInfo;
                this.info.setOrientation(orientation);
                for (Size size : sizesInfo = this.info.getSizes()) {
                    this.listLayouts(results, size, sizesMenu, sizesTabs);
                }
            } else {
                this.listLayouts(results, null, sizesMenu, sizesTabs);
            }
            return results;
        }

        private void listLayouts(List<PaneLayout> list, Size infoSize, Size[] menuSizes, LineTabsLayoutBlock.LineSize[] tabSizes) {
            for (LineTabsLayoutBlock.LineSize tab : tabSizes) {
                if (tab.isAllTabs()) {
                    this.listLayouts(list, infoSize, (Size)null, tab);
                    continue;
                }
                for (Size menu : menuSizes) {
                    this.listLayouts(list, infoSize, menu, tab);
                }
            }
        }

        private void listLayouts(List<PaneLayout> list, Size infoSize, Size menuSize, LineTabsLayoutBlock.LineSize tabSize) {
            boolean infoMustBeMinimum;
            boolean tabMustBeMinimum = infoSize != null && infoSize.isMinimum() || menuSize != null;
            boolean tabMustBeSingle = menuSize != null && menuSize.isMinimum();
            boolean bl = infoMustBeMinimum = menuSize != null && menuSize.isMinimum();
            if (tabMustBeMinimum && !tabSize.isMinimum()) {
                return;
            }
            if (tabMustBeSingle && tabSize.getTabCount() > 1) {
                return;
            }
            if (infoMustBeMinimum && infoSize != null && !infoSize.isMinimum()) {
                return;
            }
            list.add(new PaneLayout(tabSize, menuSize, infoSize));
        }

        @Override
        public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
            super.infoComponentChanged(pane, oldInfo, newInfo);
            this.info = newInfo == null ? null : newInfo.toLayoutBlock();
        }

        private class PaneLayout {
            private Size menuSize;
            private Size infoSize;
            private LineTabsLayoutBlock.LineSize tabSize;

            public PaneLayout(LineTabsLayoutBlock.LineSize tab, Size menu, Size info) {
                this.menuSize = menu;
                this.tabSize = tab;
                this.infoSize = info;
            }

            public String toString() {
                return this.getClass().getSimpleName() + "@[menu=" + this.menuSize + ", info=" + this.infoSize + ", tabs=" + this.tabSize + "]";
            }

            public boolean isPreferred() {
                if (this.tabSize == null || !this.tabSize.isPreferred() || !this.tabSize.isAllTabs()) {
                    return false;
                }
                return this.menuSize == null;
            }

            public Dimension getSize() {
                int width = this.tabSize.getWidth();
                int height = this.tabSize.getHeight();
                if (Layout.this.getPane().getTabPlacement().isHorizontal()) {
                    if (this.menuSize != null) {
                        width += this.menuSize.getWidth();
                        height = Math.max(height, this.menuSize.getHeight());
                    }
                    if (this.infoSize != null) {
                        width += this.infoSize.getWidth();
                        height = Math.max(height, this.infoSize.getHeight());
                    }
                } else {
                    if (this.menuSize != null) {
                        width = Math.max(width, this.menuSize.getWidth());
                        height += this.menuSize.getHeight();
                    }
                    if (this.infoSize != null) {
                        width = Math.max(width, this.infoSize.getWidth());
                        height += this.infoSize.getHeight();
                    }
                }
                return new Dimension(width, height);
            }

            public void apply() {
                int space;
                int tabSpace;
                int required;
                TabPane pane = Layout.this.getPane();
                AxisConversion conversion = MenuLineLayout.this.getConversion(pane);
                TabPlacement orientation = pane.getTabPlacement();
                Layout.this.tabs.setLayout(this.tabSize);
                if (this.infoSize != null && Layout.this.info != null) {
                    Layout.this.info.setLayout(this.infoSize);
                }
                if (this.menuSize == null) {
                    Layout.this.menu.getMenu().setPaneVisible(false);
                } else {
                    Layout.this.menu.getMenu().setPaneVisible(true);
                    Layout.this.menu.setLayout(this.menuSize);
                }
                if (this.menuSize != null) {
                    HashSet<Dockable> dockables = new HashSet<Dockable>();
                    for (Dockable dockable : pane.getDockables()) {
                        dockables.add(dockable);
                    }
                    for (Tab tab : this.tabSize.getTabs()) {
                        dockables.remove(tab.getDockable());
                    }
                    TabMenu tabMenu = Layout.this.menu.getMenu();
                    for (Dockable dockable : dockables) {
                        pane.putInMenu(tabMenu, dockable);
                    }
                }
                Rectangle available = conversion.viewToModel(pane.getAvailableArea());
                if (orientation.isHorizontal()) {
                    required = this.tabSize.getHeight();
                    if (this.infoSize != null) {
                        required = Math.max(required, this.infoSize.getHeight());
                    }
                    if (this.menuSize != null) {
                        required = Math.max(required, this.menuSize.getHeight());
                    }
                } else {
                    required = this.tabSize.getWidth();
                    if (this.infoSize != null) {
                        required = Math.max(required, this.infoSize.getWidth());
                    }
                    if (this.menuSize != null) {
                        required = Math.max(required, this.menuSize.getWidth());
                    }
                }
                required = Math.max(0, Math.min(required, available.height / 2));
                pane.setSelectedBounds(conversion.modelToView(new Rectangle(available.x, available.y + required, available.width, available.height - required)));
                int menuSpace = 0;
                int infoSpace = 0;
                if (orientation.isHorizontal()) {
                    space = tabSpace = this.tabSize.getWidth();
                    if (this.infoSize != null) {
                        infoSpace = this.infoSize.getWidth();
                        space += infoSpace;
                    }
                    if (this.menuSize != null) {
                        menuSpace = this.menuSize.getWidth();
                        space += menuSpace;
                    }
                } else {
                    space = tabSpace = this.tabSize.getHeight();
                    if (this.infoSize != null) {
                        infoSpace = this.infoSize.getHeight();
                        space += infoSpace;
                    }
                    if (this.menuSize != null) {
                        menuSpace = this.menuSize.getHeight();
                        space += menuSpace;
                    }
                }
                if (available.width >= space) {
                    Rectangle tabBounds = new Rectangle(available.x, available.y, available.width - space + tabSpace, required);
                    tabBounds = conversion.modelToView(tabBounds);
                    Layout.this.tabs.setBounds(tabBounds.x, tabBounds.y, tabBounds.width, tabBounds.height);
                    if (this.menuSize != null) {
                        Rectangle menuBounds = new Rectangle(available.x + tabSpace, available.y, menuSpace, required);
                        menuBounds = conversion.modelToView(menuBounds);
                        Layout.this.menu.setBounds(menuBounds.x, menuBounds.y, menuBounds.width, menuBounds.height);
                    }
                    if (this.infoSize != null && Layout.this.info != null) {
                        int reqDelta = Math.max(0, required - this.infoSize.getHeight());
                        Rectangle infoBounds = new Rectangle(available.x + available.width - infoSpace, available.y + reqDelta / 2, infoSpace, required - reqDelta);
                        infoBounds = conversion.modelToView(infoBounds);
                        Layout.this.info.setBounds(infoBounds.x, infoBounds.y, infoBounds.width, infoBounds.height);
                    }
                } else {
                    double shrinkFactor = (double)space / (double)available.width;
                    int x = available.x;
                    int width = (int)(shrinkFactor * (double)tabSpace);
                    Rectangle tabBounds = new Rectangle(x, available.y, width, required);
                    tabBounds = conversion.modelToView(tabBounds);
                    Layout.this.tabs.setBounds(tabBounds.x, tabBounds.y, tabBounds.width, tabBounds.height);
                    x += width;
                    if (this.menuSize != null) {
                        width = (int)(shrinkFactor * (double)menuSpace);
                        Rectangle menuBounds = new Rectangle(x, available.y, width, required);
                        menuBounds = conversion.modelToView(menuBounds);
                        Layout.this.menu.setBounds(menuBounds.x, menuBounds.y, menuBounds.width, menuBounds.height);
                        x += width;
                    }
                    if (this.infoSize != null) {
                        width = available.x + available.width - x;
                        int reqDelta = Math.max(0, required - this.infoSize.getHeight());
                        Rectangle infoBounds = new Rectangle(x, available.y + reqDelta / 2, width, required - reqDelta);
                        infoBounds = conversion.modelToView(infoBounds);
                        Layout.this.info.setBounds(infoBounds.x, infoBounds.y, infoBounds.width, infoBounds.height);
                    }
                }
            }
        }
    }
}

