/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundRectDropDownButton
extends JComponent
implements FocusAwareComponent {
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private Runnable afterFocusRequest;

    public RoundRectDropDownButton(BasicDropDownButtonHandler handler) {
        this.handler = handler;
        this.model = new BasicDropDownButtonModel(this, handler, handler, true){

            protected boolean inDropDownArea(int x, int y) {
                return RoundRectDropDownButton.this.inDropDownArea(x, y);
            }

            public void changed() {
                RoundRectDropDownButton.this.revalidate();
                super.changed();
            }
        };
        this.setOpaque(false);
        this.dropIcon = this.createDropIcon();
        this.model.addListener(new BasicButtonModelAdapter(){

            public void mousePressed(BasicButtonModel model, boolean mousePressed) {
                if (!mousePressed) {
                    RoundRectDropDownButton.this.requestFocusInWindow();
                    RoundRectDropDownButton.this.invokeAfterFocusRequest();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoundRectDropDownButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                RoundRectDropDownButton.this.repaint();
            }
        });
    }

    public void maybeRequestFocus() {
        this.afterFocusRequest = null;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!RoundRectDropDownButton.this.model.isMousePressed()) {
                    RoundRectDropDownButton.this.requestFocusInWindow();
                    RoundRectDropDownButton.this.invokeAfterFocusRequest();
                }
            }
        });
    }

    public void invokeOnFocusRequest(Runnable run) {
        this.afterFocusRequest = run;
    }

    private void invokeAfterFocusRequest() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (RoundRectDropDownButton.this.afterFocusRequest != null) {
                    RoundRectDropDownButton.this.afterFocusRequest.run();
                    RoundRectDropDownButton.this.afterFocusRequest = null;
                }
            }
        });
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension icon = this.model.getMaxIconSize();
        int w = Math.max(icon.width + 4, 10);
        int h = Math.max(icon.height + 4, 10);
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension(w + 6 + this.dropIcon.getIconWidth(), h);
        }
        return new Dimension(w, h + 6 + this.dropIcon.getIconHeight());
    }

    protected void paintComponent(Graphics g) {
        BasicDropDownButtonModel model = this.getModel();
        BackgroundPaint paint = model.getBackground();
        BackgroundComponent component = model.getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            protected void foreground(Graphics g) {
                RoundRectDropDownButton.this.doPaintForeground(g);
            }

            protected void background(Graphics g) {
                RoundRectDropDownButton.this.doPaintBackground(g);
            }

            protected void border(Graphics g) {
            }

            protected void children(Graphics g) {
            }

            protected void overlay(Graphics g) {
            }

            public boolean isSolid() {
                return false;
            }

            public boolean isTransparent() {
                return false;
            }
        };
        paintable.paint(g);
    }

    private void doPaintBackground(Graphics g) {
        Color background = this.getBackground();
        Color border = null;
        if (this.model.isMousePressed()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.8);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.4);
        }
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        if (border != null) {
            g.setColor(background);
            g.fillRoundRect(0, 0, w, h, 4, 4);
        }
    }

    private void doPaintForeground(Graphics g) {
        Icon icon;
        Icon drop = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = DockUtilities.disabledIcon(this, this.dropIcon);
            }
            drop = this.disabledDropIcon;
        }
        Color background = this.getBackground();
        Color border = null;
        if (this.model.isMousePressed()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.8);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.4);
        }
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        if (border != null) {
            g.setColor(border);
            g.drawRoundRect(0, 0, w, h, 4, 4);
            if (this.model.isMouseOverDropDown()) {
                if (this.model.getOrientation().isHorizontal()) {
                    int x = w - drop.getIconWidth() - 5;
                    g.drawLine(x, 0, x, h);
                } else {
                    int y = h - drop.getIconHeight() - 5;
                    g.drawLine(0, y, w, y);
                }
            }
        }
        if ((icon = this.model.getPaintIcon()) != null) {
            if (this.model.getOrientation().isHorizontal()) {
                icon.paintIcon(this, g, (w - 3 - drop.getIconWidth() + 1 - icon.getIconWidth()) / 2, (h + 1 - icon.getIconHeight()) / 2);
            } else {
                icon.paintIcon(this, g, (w + 1 - icon.getIconWidth()) / 2, (h - 3 - drop.getIconHeight() + 1 - icon.getIconHeight()) / 2);
            }
        }
        if (this.model.getOrientation().isHorizontal()) {
            drop.paintIcon(this, g, w - drop.getIconWidth() - 2, (h - drop.getIconHeight()) / 2);
        } else {
            drop.paintIcon(this, g, (w - drop.getIconWidth()) / 2, h - drop.getIconHeight() - 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            g.setColor(Colors.diffMirror(background, 0.4));
            g.drawLine(2, 3, 2, 4);
            g.drawLine(3, 2, 4, 2);
            g.drawLine(w - 2, 3, w - 2, 4);
            g.drawLine(w - 3, 2, w - 4, 2);
            g.drawLine(2, h - 3, 2, h - 4);
            g.drawLine(3, h - 2, 4, h - 2);
            g.drawLine(w - 2, h - 3, w - 2, h - 4);
            g.drawLine(w - 3, h - 2, w - 4, h - 2);
        }
    }

    public boolean inDropDownArea(int x, int y) {
        if (!this.contains(x, y)) {
            return false;
        }
        if (this.model.getOrientation().isHorizontal()) {
            return x >= this.getWidth() - this.dropIcon.getIconWidth() - 5;
        }
        return y >= this.getHeight() - this.dropIcon.getIconHeight() - 5;
    }

    public void updateUI() {
        this.disabledDropIcon = null;
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }

    protected Icon createDropIcon() {
        return new Icon(){

            public int getIconHeight() {
                return 7;
            }

            public int getIconWidth() {
                return 7;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(RoundRectDropDownButton.this.getForeground());
                g.drawLine(++x, y + 1, x + 4, y + 1);
                g.drawLine(x + 1, y + 2, x + 3, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
            }
        };
    }
}

