/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.BubblePanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BubbleButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleDisplayerTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleTabTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleTitleTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBubbleTheme
extends CDockTheme<BubbleTheme> {
    public CBubbleTheme(CControl control, BubbleTheme theme) {
        super(theme);
        this.init(control);
    }

    public CBubbleTheme(CControl control) {
        this(new BubbleTheme());
        this.init(control);
    }

    private CBubbleTheme(BubbleTheme theme) {
        super(theme, new NoStackTheme(theme));
    }

    private void init(final CControl control) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                BubbleTabTransmitter transmitter = new BubbleTabTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                BubbleTitleTransmitter transmitter = new BubbleTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(DisplayerColor.KIND_DISPLAYER_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                BubbleDisplayerTransmitter transmitter = new BubbleDisplayerTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                BubbleButtonTitleTransmitter transmitter = new BubbleButtonTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.initDefaultFontBridges(control);
    }

    @Override
    public void install(DockController controller) {
        super.install(controller);
        IconManager manager = controller.getIcons();
        Map<String, Icon> icons = DockUtilities.loadIcons("data/bibliothek/gui/dock/icons/bubble/icons.ini", "data/bibliothek/gui/dock/icons/bubble/", CBubbleTheme.class.getClassLoader());
        for (Map.Entry<String, Icon> entry : icons.entrySet()) {
            manager.setIconTheme(entry.getKey(), entry.getValue());
        }
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new BubblePanelPopupGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController controller) {
        super.uninstall(controller);
        controller.getIcons().clear(Priority.THEME);
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
    }
}

