/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.TypedUIProperties;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedPropertyUIScheme
implements UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> {
    private DockProperties properties;
    private Map<String, Link<?, ?>> links = new HashMap();
    private List<UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>>> listeners = new ArrayList<UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>>>();
    private int bound = 0;

    public TypedPropertyUIScheme(DockProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.properties = properties;
    }

    public <V, A extends V> void link(PropertyKey<A> source, TypedUIProperties.Type<V> destinationType, String destinationId) {
        String id = destinationType.getKey(destinationId);
        Link<?, ?> old = this.links.get(id);
        if (old != null) {
            old.setKey(source);
        } else {
            Link<V, A> link = new Link<V, A>(source, destinationType, destinationId);
            this.links.put(id, link);
            if (this.bound > 0) {
                link.setProperties(this.properties);
            }
        }
    }

    public <V> void unlink(TypedUIProperties.Type<V> destinationType, String destinationId) {
        String id = destinationType.getKey(destinationId);
        Link<?, ?> old = this.links.remove(id);
        if (old != null) {
            old.setProperties((DockProperties)null);
        }
    }

    @Override
    public void addListener(UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(UISchemeListener<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> listener) {
        this.listeners.remove(listener);
    }

    protected void fire(UISchemeEvent<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> event) {
        UISchemeListener[] array;
        for (UISchemeListener listener : array = this.listeners.toArray(new UISchemeListener[this.listeners.size()])) {
            listener.changed(event);
        }
    }

    @Override
    public UIBridge<Object, UIValue<Object>> getBridge(Path name, UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> properties) {
        return null;
    }

    @Override
    public Object getResource(String name, UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> properties) {
        Link<?, ?> best = this.links.get(name);
        if (best == null) {
            int offset = 0;
            for (Map.Entry<String, Link<?, ?>> entry : this.links.entrySet()) {
                int length;
                if (!name.startsWith(entry.getKey()) || (length = entry.getKey().length()) <= offset) continue;
                offset = length;
                best = entry.getValue();
            }
        }
        if (best == null) {
            return null;
        }
        return best.getValue();
    }

    @Override
    public void install(UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> properties) {
        if (this.bound == 0) {
            for (Link<?, ?> link : this.links.values()) {
                link.setProperties((DockProperties)null);
            }
        }
        ++this.bound;
    }

    @Override
    public void uninstall(UIProperties<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> properties) {
        --this.bound;
        if (this.bound == 0) {
            for (Link<?, ?> link : this.links.values()) {
                link.setProperties(this.properties);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Link<V, A extends V>
    extends PropertyValue<A> {
        private TypedUIProperties.Type<V> type;
        private String id;

        public Link(PropertyKey<A> key, TypedUIProperties.Type<V> type, String id) {
            super(key);
            this.type = type;
            this.id = id;
        }

        @Override
        protected void valueChanged(A oldValue, A newValue) {
            TypedPropertyUIScheme.this.fire(new UISchemeEvent<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>>(){

                @Override
                public Collection<Path> changedBridges(Set<Path> names) {
                    return Collections.emptyList();
                }

                @Override
                public Collection<String> changedResources(Set<String> names) {
                    if (names == null) {
                        return null;
                    }
                    String key = Link.this.type.getKey(Link.this.id);
                    ArrayList<String> result = new ArrayList<String>();
                    for (String name : names) {
                        if (!name.startsWith(key)) continue;
                        result.add(name);
                    }
                    return result;
                }

                @Override
                public UIScheme<Object, UIValue<Object>, UIBridge<Object, UIValue<Object>>> getScheme() {
                    return TypedPropertyUIScheme.this;
                }
            });
        }
    }
}

