/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.gui.dock.control.ModifierMask;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PreferenceFactory<V> {
    public static final PreferenceFactory<Boolean> FACTORY_BOOLEAN = new PreferenceFactory<Boolean>(){

        @Override
        public Boolean read(DataInputStream in) throws IOException {
            return in.readBoolean();
        }

        @Override
        public Boolean readXML(XElement element) {
            return element.getBoolean();
        }

        @Override
        public void write(Boolean value, DataOutputStream out) throws IOException {
            out.writeBoolean(value);
        }

        @Override
        public void writeXML(Boolean value, XElement element) {
            element.setBoolean(value);
        }
    };
    public static final PreferenceFactory<Integer> FACTORY_INT = new PreferenceFactory<Integer>(){

        @Override
        public Integer read(DataInputStream in) throws IOException {
            return in.readInt();
        }

        @Override
        public Integer readXML(XElement element) {
            return element.getInt();
        }

        @Override
        public void write(Integer value, DataOutputStream out) throws IOException {
            out.writeInt(value);
        }

        @Override
        public void writeXML(Integer value, XElement element) {
            element.setInt(value);
        }
    };
    public static final PreferenceFactory<String> FACTORY_STRING = new PreferenceFactory<String>(){

        @Override
        public String read(DataInputStream in) throws IOException {
            return in.readUTF();
        }

        @Override
        public String readXML(XElement element) {
            return element.getString();
        }

        @Override
        public void write(String value, DataOutputStream out) throws IOException {
            out.writeUTF(value);
        }

        @Override
        public void writeXML(String value, XElement element) {
            element.setString(value);
        }
    };
    public static final PreferenceFactory<KeyStroke> FACTORY_KEYSTROKE = new PreferenceFactory<KeyStroke>(){

        @Override
        public KeyStroke read(DataInputStream in) throws IOException {
            return KeyStroke.getKeyStroke(in.readUTF());
        }

        @Override
        public KeyStroke readXML(XElement element) {
            return KeyStroke.getKeyStroke(element.getString());
        }

        @Override
        public void write(KeyStroke value, DataOutputStream out) throws IOException {
            out.writeUTF(value.toString());
        }

        @Override
        public void writeXML(KeyStroke value, XElement element) {
            element.setString(value.toString());
        }
    };
    public static final PreferenceFactory<ModifierMask> FACTORY_MODIFIER_MASK = new PreferenceFactory<ModifierMask>(){

        @Override
        public ModifierMask read(DataInputStream in) throws IOException {
            int on = in.readInt();
            int off = in.readInt();
            return new ModifierMask(on, off);
        }

        @Override
        public ModifierMask readXML(XElement element) {
            int on = element.getInt("on");
            int off = element.getInt("off");
            return new ModifierMask(on, off);
        }

        @Override
        public void write(ModifierMask value, DataOutputStream out) throws IOException {
            out.writeInt(value.getOnmask());
            out.writeInt(value.getOffmask());
        }

        @Override
        public void writeXML(ModifierMask value, XElement element) {
            element.addInt("on", value.getOnmask());
            element.addInt("off", value.getOffmask());
        }
    };

    public void write(V var1, DataOutputStream var2) throws IOException;

    public void writeXML(V var1, XElement var2);

    public V read(DataInputStream var1) throws IOException;

    public V readXML(XElement var1);
}

