/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.action.predefined.CExternalizeAction;
import bibliothek.gui.dock.common.action.predefined.CUnmaximizeExternalizedAction;
import bibliothek.gui.dock.common.mode.CExternalizedModeArea;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.common.mode.KeyedLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.MappingLocationModeActionProvider;
import bibliothek.gui.dock.support.mode.Mode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExternalizedMode
extends ExternalizedMode<CExternalizedModeArea>
implements CLocationMode {
    private LocationModeActionProvider externalize;
    private LocationModeActionProvider unmaximize;

    public CExternalizedMode(CControl cControl) {
        this.externalize = new KeyedLocationModeActionProvider("cdockable.externalize", new CExternalizeAction(cControl));
        this.unmaximize = new KeyedLocationModeActionProvider("cdockable.unmaximize_externalized", new CUnmaximizeExternalizedAction(cControl));
        this.setActionProvider(new MappingLocationModeActionProvider(){

            @Override
            protected LocationModeActionProvider getProvider(Dockable dockable, Mode<Location> mode, DockActionSource dockActionSource) {
                if (mode instanceof CMaximizedMode && ((CMaximizedMode)mode).getUnmaximizedMode(dockable) instanceof CExternalizedMode) {
                    return CExternalizedMode.this.unmaximize;
                }
                return CExternalizedMode.this.externalize;
            }
        });
    }

    @Override
    public CLocation getCLocation(Dockable dockable) {
        CExternalizedModeArea cExternalizedModeArea = (CExternalizedModeArea)this.get(dockable);
        if (cExternalizedModeArea == null) {
            return null;
        }
        return cExternalizedModeArea.getCLocation(dockable);
    }

    @Override
    public CLocation getCLocation(Dockable dockable, Location location) {
        CModeArea cModeArea = (CModeArea)this.get(dockable);
        if (cModeArea == null) {
            return null;
        }
        return cModeArea.getCLocation(dockable, location);
    }

    @Override
    public boolean isBasicMode() {
        return true;
    }

    @Override
    public boolean respectWorkingAreas(DockStation dockStation) {
        CModeArea cModeArea = (CModeArea)this.get(dockStation);
        if (cModeArea == null) {
            return true;
        }
        return cModeArea.respectWorkingAreas();
    }
}

