/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicHandler<D extends StandardDockAction>
implements BasicTrigger,
BasicTitleViewItem<JComponent> {
    private D action;
    private BasicButtonModel model;
    private Dockable dockable;
    private Listener listener;

    public BasicHandler(D d, Dockable dockable) {
        if (d == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        this.dockable = dockable;
        this.action = d;
    }

    public void setModel(BasicButtonModel basicButtonModel) {
        this.model = basicButtonModel;
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    public D getAction() {
        return this.action;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public JComponent getItem() {
        return this.model.getOwner();
    }

    @Override
    public void setBackground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setForeground(color);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.model.setOrientation(orientation);
    }

    @Override
    public abstract void triggered();

    @Override
    public void bind() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        this.listener.updateTooltip();
        this.model.setIcon(this.action.getIcon(this.dockable));
        this.model.setDisabledIcon(this.action.getDisabledIcon(this.dockable));
        this.model.setEnabled(this.action.isEnabled(this.dockable));
        this.action.addDockActionListener(this.listener);
    }

    @Override
    public void unbind() {
        this.action.removeDockActionListener(this.listener);
    }

    protected Listener createListener() {
        return new Listener();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Listener
    implements StandardDockActionListener {
        protected Listener() {
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicHandler.this.dockable)) {
                BasicHandler.this.model.setDisabledIcon(standardDockAction.getDisabledIcon(BasicHandler.this.dockable));
            }
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicHandler.this.dockable)) {
                BasicHandler.this.model.setEnabled(standardDockAction.isEnabled(BasicHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicHandler.this.dockable)) {
                BasicHandler.this.model.setIcon(standardDockAction.getIcon(BasicHandler.this.dockable));
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicHandler.this.dockable)) {
                this.updateTooltip();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicHandler.this.dockable)) {
                this.updateTooltip();
            }
        }

        private void updateTooltip() {
            String string = BasicHandler.this.action.getTooltipText(BasicHandler.this.dockable);
            if (string == null || string.length() == 0) {
                string = BasicHandler.this.action.getText(BasicHandler.this.dockable);
            }
            BasicHandler.this.model.setToolTipText(string);
        }
    }
}

