/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DropDownActionListener;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonTrigger;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.DropDownItemHandle;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDropDownButtonHandler
implements BasicDropDownButtonTrigger,
BasicTitleViewItem<JComponent> {
    private DropDownAction action;
    private DockActionSource source;
    private Dockable dockable;
    private BasicDropDownButtonModel model;
    private Listener listener = new Listener();
    private DropDownItemHandle selection;
    private List<DockAction> actions = new ArrayList<DockAction>();
    private Map<DockAction, DropDownItemHandle> items = new HashMap<DockAction, DropDownItemHandle>();
    private JPopupMenu menu = new JPopupMenu();
    private SelectionView selectionView = new SelectionView();
    private ButtonView buttonView = new ButtonView();
    private DropDownFilter filter;

    public BasicDropDownButtonHandler(DropDownAction dropDownAction, Dockable dockable) {
        this.action = dropDownAction;
        this.dockable = dockable;
    }

    public void setModel(BasicDropDownButtonModel basicDropDownButtonModel) {
        this.model = basicDropDownButtonModel;
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.model.setOrientation(orientation);
    }

    @Override
    public void bind() {
        this.action.bind(this.dockable);
        this.filter = this.action.getFilter(this.dockable).createView(this.action, this.dockable, this.buttonView);
        this.filter.bind();
        this.source = this.action.getSubActions(this.dockable);
        int n = this.source.getDockActionCount();
        for (int i = 0; i < n; ++i) {
            DockAction dockAction = this.source.getDockAction(i);
            this.add(i, dockAction);
        }
        this.reset();
        this.selection = this.items.get(this.action.getSelection(this.dockable));
        if (this.selection != null) {
            this.selection.getView().setView(this.selectionView);
        }
        this.action.addDropDownActionListener(this.listener);
        this.action.addDockActionListener(this.listener);
        this.source.addDockActionSourceListener(this.listener);
        this.model.setEnabled(this.action.isEnabled(this.dockable));
    }

    @Override
    public void unbind() {
        this.action.removeDockActionListener(this.listener);
        this.action.removeDropDownActionListener(this.listener);
        this.source.removeDockActionSourceListener(this.listener);
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
        this.menu.removeAll();
        if (this.selection != null) {
            this.selection.getView().setView(null);
        }
        this.filter.unbind();
        this.filter = null;
        this.action.unbind(this.dockable);
        this.source = null;
        this.selection = null;
        this.items.clear();
        this.actions.clear();
    }

    @Override
    public void setBackground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        JComponent jComponent = this.getItem();
        if (jComponent != null) {
            ((Component)jComponent).setForeground(color);
        }
    }

    private void add(int n, DockAction dockAction) {
        this.actions.add(dockAction);
        DropDownViewItem dropDownViewItem = dockAction.createView(ViewTarget.DROP_DOWN, this.dockable.getController().getActionViewConverter(), this.dockable);
        if (dropDownViewItem != null) {
            DropDownItemHandle dropDownItemHandle = new DropDownItemHandle(dockAction, dropDownViewItem, this.dockable, this.action);
            dropDownItemHandle.bind();
            this.items.put(dockAction, dropDownItemHandle);
            this.menu.add((Component)dropDownViewItem.getItem());
        }
    }

    private void remove(int n) {
        DockAction dockAction = this.actions.remove(n);
        DropDownItemHandle dropDownItemHandle = this.items.remove(dockAction);
        if (dropDownItemHandle != null) {
            dropDownItemHandle.unbind();
            this.menu.remove((Component)dropDownItemHandle.getView().getItem());
        }
    }

    @Override
    public DropDownAction getAction() {
        return this.action;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public JComponent getItem() {
        return this.model.getOwner();
    }

    @Override
    public void triggered() {
        if (this.model.isMouseOverDropDown()) {
            this.popupTriggered();
        } else if (this.selection == null || !this.model.isSelectionEnabled() || !this.selection.getView().isTriggerable(true)) {
            this.popupTriggered();
        } else if (this.selection.getView().isTriggerable(true)) {
            this.selection.getView().triggered();
        }
    }

    @Override
    public void popupTriggered() {
        JComponent jComponent = this.model.getOwner();
        if (this.model.getOrientation().isHorizontal()) {
            this.menu.show(jComponent, 0, jComponent.getHeight());
        } else {
            this.menu.show(jComponent, jComponent.getWidth(), 0);
        }
    }

    public void updateUI() {
        if (this.menu != null) {
            SwingUtilities.updateComponentTreeUI(this.menu);
        }
    }

    protected ButtonView getButtonView() {
        return this.buttonView;
    }

    protected void reset() {
        this.model.setSelectionEnabled(false);
        if (this.filter != null) {
            this.filter.setDisabledIcon(null);
            this.filter.setEnabled(true);
            this.filter.setIcon(null);
            this.filter.setSelected(false);
            this.filter.setText(null);
            this.filter.setTooltip(null);
        }
        this.update();
    }

    protected void update() {
        if (this.filter != null) {
            this.filter.update(this.selection == null ? null : this.selection.getView());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements StandardDockActionListener,
    DropDownActionListener,
    DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.dockable)) {
                BasicDropDownButtonHandler.this.model.setEnabled(standardDockAction.isEnabled(BasicDropDownButtonHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.dockable)) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.dockable)) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.dockable)) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (set.contains(BasicDropDownButtonHandler.this.dockable)) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void selectionChanged(DropDownAction dropDownAction, Set<Dockable> set, DockAction dockAction) {
            if (BasicDropDownButtonHandler.this.selection != null) {
                BasicDropDownButtonHandler.this.selection.getView().setView(null);
            }
            BasicDropDownButtonHandler.this.reset();
            BasicDropDownButtonHandler.this.selection = (DropDownItemHandle)BasicDropDownButtonHandler.this.items.get(dockAction);
            if (BasicDropDownButtonHandler.this.selection != null) {
                BasicDropDownButtonHandler.this.selection.getView().setView(BasicDropDownButtonHandler.this.selectionView);
            }
            BasicDropDownButtonHandler.this.model.changed();
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                BasicDropDownButtonHandler.this.add(i, dockActionSource.getDockAction(i));
            }
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n2; i >= n; --i) {
                BasicDropDownButtonHandler.this.remove(i);
            }
        }
    }

    protected class ButtonView
    implements DropDownView {
        protected ButtonView() {
        }

        public void setDisabledIcon(Icon icon) {
            BasicDropDownButtonHandler.this.model.setDisabledIcon(icon);
        }

        public void setEnabled(boolean bl) {
            BasicDropDownButtonHandler.this.model.setSelectionEnabled(bl);
        }

        public void setIcon(Icon icon) {
            BasicDropDownButtonHandler.this.model.setIcon(icon);
        }

        public void setSelected(boolean bl) {
            BasicDropDownButtonHandler.this.model.setSelected(bl);
        }

        public void setText(String string) {
        }

        public void setTooltip(String string) {
            BasicDropDownButtonHandler.this.model.setToolTipText(string);
        }
    }

    protected class SelectionView
    implements DropDownView {
        protected SelectionView() {
        }

        public void setEnabled(boolean bl) {
            BasicDropDownButtonHandler.this.model.setSelectionEnabled(bl);
            BasicDropDownButtonHandler.this.filter.setEnabled(bl);
            BasicDropDownButtonHandler.this.update();
        }

        public void setIcon(Icon icon) {
            BasicDropDownButtonHandler.this.filter.setIcon(icon);
            BasicDropDownButtonHandler.this.update();
        }

        public void setDisabledIcon(Icon icon) {
            BasicDropDownButtonHandler.this.filter.setDisabledIcon(icon);
            BasicDropDownButtonHandler.this.update();
        }

        public void setSelected(boolean bl) {
            BasicDropDownButtonHandler.this.filter.setSelected(bl);
            BasicDropDownButtonHandler.this.update();
        }

        public void setText(String string) {
            BasicDropDownButtonHandler.this.filter.setText(string);
            BasicDropDownButtonHandler.this.update();
        }

        public void setTooltip(String string) {
            BasicDropDownButtonHandler.this.filter.setTooltip(string);
            BasicDropDownButtonHandler.this.update();
        }
    }
}

