/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeProperties;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemePropertyFactory<T extends DockTheme>
implements ThemeFactory {
    private Constructor<T> constructor;
    private ThemeProperties properties;
    private ResourceBundle bundle;
    private DockUI ui;

    public ThemePropertyFactory(Class<T> clazz) {
        this(clazz, null, null);
    }

    public ThemePropertyFactory(Class<T> clazz, ResourceBundle resourceBundle) {
        this(clazz, resourceBundle, null);
    }

    public ThemePropertyFactory(Class<T> clazz, DockUI dockUI) {
        this(clazz, null, dockUI);
    }

    public ThemePropertyFactory(Class<T> clazz, ResourceBundle resourceBundle, DockUI dockUI) {
        if (clazz == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        this.properties = clazz.getAnnotation(ThemeProperties.class);
        if (this.properties == null) {
            throw new IllegalArgumentException("Theme misses annotation ThemeProperties");
        }
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Missing default constructor", noSuchMethodException);
        }
        this.bundle = resourceBundle;
        this.ui = dockUI;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public DockUI getUi() {
        return this.ui;
    }

    public T create() {
        try {
            return (T)((DockTheme)this.constructor.newInstance(new Object[0]));
        }
        catch (Exception exception) {
            System.err.println("Can't create theme due an unknown reason");
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String[] getAuthors() {
        return this.properties.authors();
    }

    protected String getString(String string) {
        if (this.bundle != null) {
            return this.bundle.getString(string);
        }
        if (this.ui != null) {
            return this.ui.getString(string);
        }
        return DockUI.getDefaultDockUI().getString(string);
    }

    @Override
    public String getDescription() {
        return this.getString(this.properties.descriptionBundle());
    }

    @Override
    public String getName() {
        return this.getString(this.properties.nameBundle());
    }

    @Override
    public URI[] getWebpages() {
        try {
            String[] stringArray = this.properties.webpages();
            URI[] uRIArray = new URI[stringArray.length];
            for (int i = 0; i < uRIArray.length; ++i) {
                uRIArray[i] = new URI(stringArray[i]);
            }
            return uRIArray;
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.print("Can't create urls due an unknown reason");
            uRISyntaxException.printStackTrace();
            return null;
        }
    }
}

