/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.BasicColorScheme;
import bibliothek.gui.dock.themes.basic.BasicCombiner;
import bibliothek.gui.dock.themes.basic.BasicDisplayerFactory;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.basic.BasicDockableSelection;
import bibliothek.gui.dock.themes.basic.BasicMovingImageFactory;
import bibliothek.gui.dock.themes.basic.BasicStackDockComponent;
import bibliothek.gui.dock.themes.basic.BasicStationPaint;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.themes.color.DockableSelectionColor;
import bibliothek.gui.dock.themes.color.ExtendingColorScheme;
import bibliothek.gui.dock.themes.color.StationPaintColor;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.NullPriorityValue;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.gui.dock.util.laf.LookAndFeelColorsListener;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.util.Path;
import java.awt.Color;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThemeProperties(nameBundle="theme.basic", descriptionBundle="theme.basic.description", authors={"Benjamin Sigg"}, webpages={})
public class BasicTheme
implements DockTheme {
    private NullPriorityValue<Combiner> combiner = new NullPriorityValue();
    private NullPriorityValue<StationPaint> paint = new NullPriorityValue();
    private NullPriorityValue<DisplayerFactory> displayerFactory = new NullPriorityValue();
    private NullPriorityValue<DockTitleFactory> titleFactory = new NullPriorityValue();
    private NullPriorityValue<DockableMovingImageFactory> movingImage = new NullPriorityValue();
    private NullPriorityValue<StackDockComponentFactory> stackDockComponentFactory = new NullPriorityValue();
    private NullPriorityValue<TabPlacement> tabPlacement = new NullPriorityValue();
    private DockThemeExtension[] extensions;
    public static final PropertyKey<ColorScheme> BASIC_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.BasicTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> propertyKey, DockProperties dockProperties) {
            return new BasicColorScheme();
        }
    }, true);
    private PropertyValue<ColorScheme> colorScheme = new PropertyValue<ColorScheme>(BASIC_COLOR_SCHEME){

        @Override
        protected void valueChanged(ColorScheme colorScheme, ColorScheme colorScheme2) {
            ColorScheme colorScheme3 = (ColorScheme)this.getValue();
            if (colorScheme3 != null) {
                colorScheme3.updateUI();
            }
            BasicTheme.this.updateColors();
        }
    };
    private NullPriorityValue<DockableSelection> selection = new NullPriorityValue();
    private DockController controller;
    private UIListener uiListener = new UIListener(){

        public void updateUI(DockController dockController) {
            BasicTheme.this.updateUI();
        }

        public void themeChanged(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
        }

        public void themeWillChange(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
        }
    };
    private LookAndFeelColorsListener colorListener = new LookAndFeelColorsListener(){

        public void colorChanged(String string) {
            this.colorsChanged();
        }

        public void colorsChanged() {
            if (((ColorScheme)BasicTheme.this.colorScheme.getValue()).updateUI()) {
                BasicTheme.this.updateColors();
            }
        }
    };

    public BasicTheme() {
        this.setCombiner(new BasicCombiner(), Priority.DEFAULT);
        this.setPaint(new BasicStationPaint(), Priority.DEFAULT);
        this.setDisplayerFactory(new BasicDisplayerFactory(), Priority.DEFAULT);
        this.setTitleFactory(new BasicDockTitleFactory(), Priority.DEFAULT);
        this.setMovingImageFactory(new BasicMovingImageFactory(), Priority.DEFAULT);
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            public StackDockComponent create(StackDockComponentParent stackDockComponentParent) {
                return new BasicStackDockComponent(stackDockComponentParent);
            }
        }, Priority.DEFAULT);
        this.setDockableSelection(new BasicDockableSelection(), Priority.DEFAULT);
        this.setTabPlacement(TabPlacement.BOTTOM_OF_DOCKABLE, Priority.DEFAULT);
    }

    @Override
    public void install(DockController dockController, DockThemeExtension[] dockThemeExtensionArray) {
        this.extensions = dockThemeExtensionArray;
        for (DockThemeExtension dockThemeExtension : dockThemeExtensionArray) {
            dockThemeExtension.install(dockController, this);
        }
        this.install(dockController);
        for (DockThemeExtension dockThemeExtension : dockThemeExtensionArray) {
            dockThemeExtension.installed(dockController, this);
        }
    }

    protected void install(DockController dockController) {
        if (this.controller != null) {
            throw new IllegalStateException("Theme is already in use");
        }
        this.controller = dockController;
        dockController.addUIListener(this.uiListener);
        DockUI.getDefaultDockUI().addLookAndFeelColorsListener(this.colorListener);
        this.updateUI();
        dockController.getProperties().set(StackDockStation.COMPONENT_FACTORY, this.stackDockComponentFactory.get(), Priority.THEME);
        dockController.getProperties().set(StackDockStation.TAB_PLACEMENT, this.tabPlacement.get(), Priority.THEME);
        this.colorScheme.setProperties(dockController);
        this.updateColors();
    }

    @Override
    public void uninstall(DockController dockController) {
        if (this.controller != dockController) {
            throw new IllegalArgumentException("Trying to uninstall a controller which is not installed");
        }
        dockController.getProperties().unset(StackDockStation.COMPONENT_FACTORY, Priority.THEME);
        dockController.getProperties().unset(StackDockStation.TAB_PLACEMENT, Priority.THEME);
        dockController.getColors().clear(Priority.THEME);
        dockController.removeUIListener(this.uiListener);
        DockUI.getDefaultDockUI().removeLookAndFeelColorsListener(this.colorListener);
        this.colorScheme.setProperties((DockProperties)null);
        for (DockThemeExtension dockThemeExtension : this.extensions) {
            dockThemeExtension.uninstall(dockController, this);
        }
        this.controller = null;
    }

    public void updateUI() {
        ColorScheme colorScheme = this.colorScheme.getValue();
        if (colorScheme != null && colorScheme.updateUI()) {
            this.updateColors();
        }
        if (this.selection != null) {
            SwingUtilities.updateComponentTreeUI(this.selection.get().getComponent());
        }
    }

    protected void updateColors() {
        ColorScheme colorScheme = this.colorScheme.getValue();
        if (this.controller != null && colorScheme != null) {
            colorScheme = new ExtendingColorScheme(colorScheme, this.controller);
            this.controller.getColors().lockUpdate();
            this.controller.getColors().clear(Priority.THEME);
            colorScheme.transmitAll(Priority.THEME, this.controller.getColors());
            this.updateColor("title.active.left", null);
            this.updateColor("title.inactive.left", null);
            this.updateColor("title.active.right", null);
            this.updateColor("title.inactive.right", null);
            this.updateColor("title.active.text", null);
            this.updateColor("title.inactive.text", null);
            this.updateColor("title.station.active", null);
            this.updateColor("title.station.active.text", null);
            this.updateColor("title.station.inactive", null);
            this.updateColor("title.station.inactive.text", null);
            this.updateColor("title.flap.active", null);
            this.updateColor("title.flap.active.text", null);
            this.updateColor("title.flap.inactive", null);
            this.updateColor("title.flap.inactive.text", null);
            this.updateColor("title.flap.selected", null);
            this.updateColor("title.flap.selected.text", null);
            this.updateColor("stack.tab.foreground", null);
            this.updateColor("stack.tab.foreground.selected", null);
            this.updateColor("stack.tab.foreground.focused", null);
            this.updateColor("stack.tab.background", null);
            this.updateColor("stack.tab.background.selected", null);
            this.updateColor("stack.tab.background.focused", null);
            this.updateColor("paint.line", null);
            this.updateColor("paint.divider", null);
            this.updateColor("paint.insertion", null);
            this.updateColorBridge(DockColor.KIND_DOCK_COLOR);
            this.updateColorBridge(TabColor.KIND_TAB_COLOR);
            this.updateColorBridge(TitleColor.KIND_TITLE_COLOR);
            this.updateColorBridge(ActionColor.KIND_ACTION_COLOR);
            this.updateColorBridge(DisplayerColor.KIND_DISPLAYER_COLOR);
            this.updateColorBridge(StationPaintColor.KIND_STATION_PAINT_COLOR);
            this.updateColorBridge(DockableSelectionColor.KIND_DOCKABLE_SELECTION_COLOR);
            this.controller.getColors().unlockUpdate();
        }
    }

    protected void updateColor(String string, Color color) {
        Color color2 = this.colorScheme.getValue().getColor(string);
        if (color2 == null) {
            color2 = color;
        }
        this.controller.getColors().put(Priority.THEME, string, color2);
    }

    protected void updateColorBridge(Path path) {
        ColorBridgeFactory colorBridgeFactory = this.colorScheme.getValue().getBridgeFactory(path);
        if (colorBridgeFactory != null) {
            ColorBridge colorBridge = colorBridgeFactory.create(this.controller.getColors());
            this.controller.getColors().publish(Priority.THEME, path, colorBridge);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    protected void setColorSchemeKey(PropertyKey<ColorScheme> propertyKey) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.colorScheme.setKey(propertyKey);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.setValue(colorScheme);
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme.getValue();
    }

    public void setStackDockComponentFactory(StackDockComponentFactory stackDockComponentFactory) {
        this.setStackDockComponentFactory(stackDockComponentFactory, Priority.CLIENT);
    }

    public void setStackDockComponentFactory(StackDockComponentFactory stackDockComponentFactory, Priority priority) {
        this.stackDockComponentFactory.set(priority, stackDockComponentFactory);
    }

    public void setMovingImageFactory(DockableMovingImageFactory dockableMovingImageFactory) {
        this.setMovingImageFactory(dockableMovingImageFactory, Priority.CLIENT);
    }

    public void setMovingImageFactory(DockableMovingImageFactory dockableMovingImageFactory, Priority priority) {
        this.movingImage.set(priority, dockableMovingImageFactory);
    }

    public void setCombiner(Combiner combiner) {
        this.setCombiner(combiner, Priority.CLIENT);
    }

    public void setCombiner(Combiner combiner, Priority priority) {
        this.combiner.set(priority, combiner);
    }

    public void setPaint(StationPaint stationPaint) {
        this.setPaint(stationPaint, Priority.CLIENT);
    }

    public void setPaint(StationPaint stationPaint, Priority priority) {
        this.paint.set(priority, stationPaint);
    }

    public void setDisplayerFactory(DisplayerFactory displayerFactory) {
        this.setDisplayerFactory(displayerFactory, Priority.CLIENT);
    }

    public void setDisplayerFactory(DisplayerFactory displayerFactory, Priority priority) {
        this.displayerFactory.set(priority, displayerFactory);
    }

    public void setTitleFactory(DockTitleFactory dockTitleFactory) {
        this.setTitleFactory(dockTitleFactory, Priority.CLIENT);
    }

    public void setTitleFactory(DockTitleFactory dockTitleFactory, Priority priority) {
        this.titleFactory.set(priority, dockTitleFactory);
        if (this.controller != null) {
            this.controller.getDockTitleManager().registerTheme("theme", this.titleFactory.get());
        }
    }

    public void setDockableSelection(DockableSelection dockableSelection) {
        this.setDockableSelection(dockableSelection, Priority.CLIENT);
    }

    public void setDockableSelection(DockableSelection dockableSelection, Priority priority) {
        this.selection.set(priority, dockableSelection);
    }

    public void setTabPlacement(TabPlacement tabPlacement) {
        this.setTabPlacement(tabPlacement, Priority.CLIENT);
    }

    public void setTabPlacement(TabPlacement tabPlacement, Priority priority) {
        this.tabPlacement.set(priority, tabPlacement);
    }

    public TabPlacement getTabPlacement() {
        return this.tabPlacement.get();
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.movingImage.get();
    }

    @Override
    public Combiner getCombiner(DockStation dockStation) {
        return this.combiner.get();
    }

    @Override
    public StationPaint getPaint(DockStation dockStation) {
        return this.paint.get();
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.displayerFactory.get();
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController dockController) {
        return this.titleFactory.get();
    }

    @Override
    public DockableSelection getDockableSelection(DockController dockController) {
        return this.selection.get();
    }
}

