/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import java.util.HashMap;
import java.util.Map;

public class DockableVisibilityManager
extends DockStationAdapter {
    private DockStationListenerManager listeners;
    private Map<Dockable, Boolean> visibility = new HashMap<Dockable, Boolean>();

    public DockableVisibilityManager(DockStationListenerManager dockStationListenerManager) {
        if (dockStationListenerManager == null) {
            throw new IllegalArgumentException("Listeners must not be null");
        }
        this.listeners = dockStationListenerManager;
        dockStationListenerManager.addListener(this);
    }

    public void fire() {
        DockStation dockStation = this.listeners.getStation();
        int n = dockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = dockStation.getDockable(i);
            boolean bl = dockStation.isVisible(dockable);
            if (this.visibility.containsKey(dockable) && this.visibility.get(dockable) == bl) continue;
            this.listeners.fireDockableVisibilitySet(dockable, bl);
            this.visibility.put(dockable, bl);
        }
    }

    public void dockableAdded(DockStation dockStation, Dockable dockable) {
        boolean bl = dockStation.isVisible(dockable);
        this.listeners.fireDockableVisibilitySet(dockable, bl);
        this.visibility.put(dockable, bl);
    }

    public void dockableRemoved(DockStation dockStation, Dockable dockable) {
        Boolean bl = this.visibility.remove(dockable);
        if (bl != null && bl.booleanValue()) {
            this.listeners.fireDockableVisibilitySet(dockable, false);
        }
    }
}

