/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.extension.gui.dock.theme.flat.FlatTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class FlatTab
extends JPanel
implements CombinedTab,
DockableFocusListener {
    private Dockable dockable;
    private DockController controller;
    private FlatTabPane pane;
    private OrientedLabel label = new OrientedLabel(){

        protected void updateFonts() {
            FlatTab.this.updateFonts();
        }
    };
    private boolean focused = false;
    private TabColor borderSelectedOut;
    private TabColor borderSelectedCenter;
    private TabColor borderFocusedOut;
    private TabColor borderFocusedCenter;
    private TabColor borderOut;
    private TabColor borderCenter;
    private TabColor border;
    private TabColor backgroundSelectedTop;
    private TabColor backgroundSelectedBottom;
    private TabColor backgroundFocusedTop;
    private TabColor backgroundFocusedBottom;
    private TabColor backgroundTop;
    private TabColor backgroundBottom;
    private TabColor background;
    private TabColor foreground;
    private TabColor foregroundSelected;
    private TabColor foregroundFocused;
    private TabFont fontFocused;
    private TabFont fontSelected;
    private TabFont fontUnselected;
    private int zOrder;
    private TabPlacement orientation = TabPlacement.BOTTOM_OF_DOCKABLE;

    public FlatTab(FlatTabPane flatTabPane, Dockable dockable) {
        this.pane = flatTabPane;
        this.dockable = dockable;
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.borderSelectedOut = new FlatTabColor("stack.tab.border.out.selected", dockable);
        this.borderSelectedCenter = new FlatTabColor("stack.tab.border.center.selected", dockable);
        this.borderFocusedOut = new FlatTabColor("stack.tab.border.out.focused", dockable);
        this.borderFocusedCenter = new FlatTabColor("stack.tab.border.center.focused", dockable);
        this.borderOut = new FlatTabColor("stack.tab.border.out", dockable);
        this.borderCenter = new FlatTabColor("stack.tab.border.center", dockable);
        this.border = new FlatTabColor("stack.tab.border", dockable);
        this.backgroundSelectedTop = new FlatTabColor("stack.tab.background.top.selected", dockable);
        this.backgroundSelectedBottom = new FlatTabColor("stack.tab.background.bottom.selected", dockable);
        this.backgroundFocusedTop = new FlatTabColor("stack.tab.background.top.focused", dockable);
        this.backgroundFocusedBottom = new FlatTabColor("stack.tab.background.bottom.focused", dockable);
        this.backgroundTop = new FlatTabColor("stack.tab.background.top", dockable);
        this.backgroundBottom = new FlatTabColor("stack.tab.background.bottom", dockable);
        this.background = new FlatTabColor("stack.tab.background", dockable);
        this.foreground = new FlatTabColor("stack.tab.foreground", dockable){

            protected void changed(Color color, Color color2) {
                if (!FlatTab.this.isSelected()) {
                    FlatTab.this.setForeground(color2);
                }
            }
        };
        this.foregroundSelected = new FlatTabColor("stack.tab.foreground.selected", dockable){

            protected void changed(Color color, Color color2) {
                if (FlatTab.this.isSelected() && !FlatTab.this.focused) {
                    FlatTab.this.setForeground(color2);
                }
            }
        };
        this.foregroundFocused = new FlatTabColor("stack.tab.foreground.focused", dockable){

            protected void changed(Color color, Color color2) {
                if (FlatTab.this.focused) {
                    FlatTab.this.setForeground(color2);
                }
            }
        };
        this.fontFocused = new FlatTabFont("tab.focused", dockable);
        this.fontSelected = new FlatTabFont("tab.selected", dockable);
        this.fontUnselected = new FlatTabFont("tab.unselected", dockable);
        this.setController(flatTabPane.getController());
        this.setOpaque(false);
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FlatTab.this.pane.setSelectedDockable(FlatTab.this.dockable);
            }
        });
        this.setBorder(new Border(){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                Color color = null;
                Color color2 = null;
                if (FlatTab.this.focused) {
                    color = (Color)FlatTab.this.borderFocusedOut.value();
                    color2 = (Color)FlatTab.this.borderFocusedCenter.value();
                }
                if (FlatTab.this.isSelected()) {
                    if (color == null) {
                        color = (Color)FlatTab.this.borderSelectedOut.value();
                    }
                    if (color2 == null) {
                        color2 = (Color)FlatTab.this.borderSelectedCenter.value();
                    }
                }
                if (color == null) {
                    color = (Color)FlatTab.this.borderOut.value();
                }
                if (color2 == null) {
                    color2 = (Color)FlatTab.this.borderCenter.value();
                }
                if (color == null || color2 == null) {
                    Color color3 = (Color)FlatTab.this.border.value();
                    if (color3 == null) {
                        color3 = (Color)FlatTab.this.background.value();
                    }
                    if (color3 == null) {
                        color3 = FlatTab.this.getBackground();
                    }
                    if (color == null) {
                        color = color3;
                    }
                    if (color2 == null) {
                        color2 = FlatTab.this.isSelected() ? color3.brighter() : color3.darker();
                    }
                }
                if (FlatTab.this.orientation.isHorizontal()) {
                    graphics2D.setPaint(new GradientPaint(n, n2, color, n, n2 + n4 / 2, color2));
                    graphics.drawLine(n, n2, n, n2 + n4 / 2);
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 / 2);
                    graphics2D.setPaint(new GradientPaint(n, n2 + n4, color, n, n2 + n4 / 2, color2));
                    graphics.drawLine(n, n2 + n4, n, n2 + n4 / 2);
                    graphics.drawLine(n + n3 - 1, n2 + n4, n + n3 - 1, n2 + n4 / 2);
                } else {
                    graphics2D.setPaint(new GradientPaint(n, n2, color, n + n3 / 2, n2, color2));
                    graphics.drawLine(n, n2, n + n3 / 2, n2);
                    graphics.drawLine(n, n2 + n4 - 1, n + n3 / 2, n2 + n4 - 1);
                    graphics2D.setPaint(new GradientPaint(n + n3, n2, color, n + n3 / 2, n2, color2));
                    graphics.drawLine(n + n3, n2, n + n3 / 2, n2);
                    graphics.drawLine(n + n3, n2 + n4 - 1, n + n3 / 2, n2 + n4 - 1);
                }
                graphics2D.setPaint(paint);
            }

            public Insets getBorderInsets(Component component) {
                return new Insets(0, 1, 0, 1);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        });
    }

    public void updateForeground() {
        if (this.focused) {
            this.setForeground((Color)this.foregroundFocused.value());
        } else if (this.isSelected()) {
            this.setForeground((Color)this.foregroundSelected.value());
        } else {
            this.setForeground((Color)this.foreground.value());
        }
    }

    public void updateFonts() {
        if (this.focused) {
            this.setFontModifier(this.fontFocused.font());
        } else if (this.isSelected()) {
            this.setFontModifier(this.fontSelected.font());
        } else {
            this.setFontModifier(this.fontUnselected.font());
        }
    }

    public void setFontModifier(FontModifier fontModifier) {
        this.label.setFontModifier(fontModifier);
    }

    public FontModifier getFontModifier() {
        return this.label.getFontModifier();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setController(DockController dockController) {
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this);
        }
        this.controller = dockController;
        if (dockController != null) {
            dockController.addDockableFocusListener(this);
        }
        this.borderSelectedOut.connect(dockController);
        this.borderSelectedCenter.connect(dockController);
        this.borderFocusedOut.connect(dockController);
        this.borderFocusedCenter.connect(dockController);
        this.borderOut.connect(dockController);
        this.borderCenter.connect(dockController);
        this.border.connect(dockController);
        this.backgroundSelectedTop.connect(dockController);
        this.backgroundSelectedBottom.connect(dockController);
        this.backgroundFocusedTop.connect(dockController);
        this.backgroundFocusedBottom.connect(dockController);
        this.backgroundTop.connect(dockController);
        this.backgroundBottom.connect(dockController);
        this.background.connect(dockController);
        this.foregroundSelected.connect(dockController);
        this.foregroundFocused.connect(dockController);
        this.foreground.connect(dockController);
        this.fontFocused.connect(dockController);
        this.fontSelected.connect(dockController);
        this.fontUnselected.connect(dockController);
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
        this.focused = this.dockable == dockableFocusEvent.getNewFocusOwner();
        this.updateForeground();
        this.updateFonts();
        this.repaint();
    }

    public TabPane getTabParent() {
        return this.pane;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public JComponent getComponent() {
        return this;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return false;
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.label.addMouseListener(mouseInputListener);
        this.label.addMouseMotionListener(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
        this.label.removeMouseListener(mouseInputListener);
        this.label.removeMouseMotionListener(mouseInputListener);
    }

    public Dimension getPreferredSize(Tab[] tabArray) {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 10 || dimension.height < 10) {
            dimension = new Dimension(dimension);
            dimension.width = Math.max(dimension.width, 10);
            dimension.height = Math.max(dimension.height, 10);
        }
        return dimension;
    }

    public Dimension getMinimumSize(Tab[] tabArray) {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 10 || dimension.height < 10) {
            dimension = new Dimension(dimension);
            dimension.width = Math.max(dimension.width, 10);
            dimension.height = Math.max(dimension.height, 10);
        }
        return dimension;
    }

    public void setTooltip(String string) {
        this.setToolTipText(string);
    }

    public void setPaneVisible(boolean bl) {
        this.pane.getTabHandler().setVisible(this, bl);
    }

    public boolean isPaneVisible() {
        return this.pane.getTabHandler().isVisible(this);
    }

    public boolean isSelected() {
        return this.pane.getSelectedDockable() == this.dockable;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public Insets getOverlap(TabPaneComponent tabPaneComponent) {
        return new Insets(0, 0, 0, 0);
    }

    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        this.orientation = tabPlacement;
        this.label.setHorizontal(tabPlacement.isHorizontal());
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = null;
        Color color2 = null;
        if (this.focused) {
            color = (Color)this.backgroundFocusedTop.value();
            color2 = (Color)this.backgroundFocusedBottom.value();
        }
        if (this.isSelected()) {
            if (color == null) {
                color = (Color)this.backgroundSelectedTop.value();
            }
            if (color2 == null) {
                color2 = (Color)this.backgroundSelectedBottom.value();
            }
        }
        if (color == null) {
            color = (Color)this.backgroundTop.value();
        }
        if (color2 == null) {
            color2 = (Color)this.backgroundBottom.value();
        }
        if (color == null || color2 == null) {
            Color color3 = (Color)this.background.value();
            if (color3 == null) {
                color3 = this.getBackground();
            }
            if (color2 == null) {
                color2 = color3;
            }
            if (color == null) {
                color = this.isSelected() ? color3.brighter() : color3;
            }
        }
        if (color.equals(color2)) {
            graphics.setColor(color);
        } else if (this.orientation.isHorizontal()) {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2));
        } else {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, n, 0.0f, color2));
        }
        graphics.fillRect(0, 0, n, n2);
        graphics2D.setPaint(paint);
        super.paintComponent(graphics);
    }

    private class FlatTabFont
    extends TabFont {
        public FlatTabFont(String string, Dockable dockable) {
            super(string, FlatTab.this.pane.getStation(), dockable);
        }

        protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
            FlatTab.this.updateFonts();
        }
    }

    private class FlatTabColor
    extends TabColor {
        public FlatTabColor(String string, Dockable dockable) {
            super(string, FlatTab.this.pane.getStation(), dockable, null);
        }

        protected void changed(Color color, Color color2) {
            FlatTab.this.repaint();
        }
    }
}

