/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class BubbleColorAnimation {
    private int duration = 1000;
    private Map<String, Entry> colors = new HashMap<String, Entry>();
    private Timer timer;
    private long time = 0L;
    private List<Runnable> tasks = new ArrayList<Runnable>();

    public BubbleColorAnimation() {
        this.timer = new Timer(25, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BubbleColorAnimation.this.pulse();
            }
        });
        this.timer.setCoalesce(true);
    }

    public void putColors(String string, Color color, Color color2) {
        Entry entry = this.colors.get(string);
        if (entry == null) {
            entry = new Entry();
            this.colors.put(string, entry);
        }
        entry.setColors(color, color2);
    }

    public void putColor(String string, Color color) {
        Entry entry = this.colors.get(string);
        if (entry == null) {
            entry = new Entry();
            entry.age = 0;
            entry.source = color;
            this.colors.put(string, entry);
        } else {
            entry.setDestination(color);
            this.start();
        }
    }

    public Color getColor(String string) {
        Entry entry = this.colors.get(string);
        if (entry == null) {
            return null;
        }
        return entry.getColor();
    }

    public void addTask(Runnable runnable) {
        this.tasks.add(runnable);
    }

    public void removeTask(Runnable runnable) {
        this.tasks.remove(runnable);
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public int getDuration() {
        return this.duration;
    }

    public void stop() {
        this.timer.stop();
    }

    public void kick() {
        if (this.timer.isRunning()) {
            this.stop();
            for (Entry object : this.colors.values()) {
                object.kick();
            }
            for (Runnable runnable : this.tasks) {
                runnable.run();
            }
        }
    }

    protected void start() {
        if (!this.timer.isRunning()) {
            this.time = System.currentTimeMillis();
            this.timer.start();
        }
    }

    protected void pulse() {
        boolean bl = false;
        long l = System.currentTimeMillis();
        int n = (int)(l - this.time);
        this.time = l;
        for (Entry object : this.colors.values()) {
            bl = object.step(n) | bl;
        }
        if (!bl) {
            this.timer.stop();
        }
        for (Runnable runnable : this.tasks) {
            runnable.run();
        }
    }

    private class Entry {
        private Color source;
        private Color destination;
        private Color intermediate;
        private int age;

        private Entry() {
        }

        public Color getColor() {
            if (this.age <= 0) {
                return this.source;
            }
            if (this.age >= BubbleColorAnimation.this.duration) {
                return this.destination;
            }
            Color color = this.intermediate == null ? this.source : this.intermediate;
            double d = (double)(BubbleColorAnimation.this.duration - this.age) / (double)BubbleColorAnimation.this.duration;
            double d2 = (double)this.age / (double)BubbleColorAnimation.this.duration;
            return new Color(Math.max(0, Math.min(255, (int)(d * (double)color.getRed() + d2 * (double)this.destination.getRed()))), Math.max(0, Math.min(255, (int)(d * (double)color.getGreen() + d2 * (double)this.destination.getGreen()))), Math.max(0, Math.min(255, (int)(d * (double)color.getBlue() + d2 * (double)this.destination.getBlue()))));
        }

        public boolean step(int n) {
            if (this.destination == null) {
                return false;
            }
            this.age += n;
            if (this.age >= BubbleColorAnimation.this.duration) {
                this.age = 0;
                this.source = this.destination;
                this.destination = null;
                this.intermediate = null;
                return false;
            }
            return true;
        }

        public void kick() {
            this.age = 0;
            if (this.destination != null) {
                this.source = this.destination;
            }
            this.destination = null;
            this.intermediate = null;
        }

        public void setColors(Color color, Color color2) {
            if (this.age == 0) {
                this.source = color2;
            } else {
                this.source = color;
                this.destination = color2;
            }
        }

        public void setDestination(Color color) {
            if (this.destination == null || !this.destination.equals(color)) {
                if (this.age == 0) {
                    this.destination = color;
                    this.intermediate = null;
                } else if (this.source != null && this.source.equals(color)) {
                    this.intermediate = this.getColor();
                    this.source = this.destination;
                    this.destination = color;
                    this.age = 1;
                } else {
                    this.intermediate = this.getColor();
                    this.source = null;
                    this.destination = color;
                    this.age = 1;
                }
            }
        }
    }
}

