/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.station.split;

import bibliothek.extension.gui.dock.station.split.SizeManager;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.Dimension;

public class LbSplitLayoutManager
extends DefaultSplitLayoutManager {
    private static final double MINIMUM_ORIGINAL_SIZE = 0.25;
    private static final Dimension DEFAULT_MINIMUM_SIZE = new Dimension(10, 10);
    private SizeManager sizeManager;

    public LbSplitLayoutManager(SizeManager sizeManager) {
        if (sizeManager == null) {
            throw new NullPointerException("sizeManager must not be null");
        }
        this.sizeManager = sizeManager;
    }

    public void calculateDivider(SplitDockStation splitDockStation, PutInfo putInfo, Leaf leaf) {
        double d;
        Dockable dockable = putInfo.getDockable();
        if (leaf != null) {
            super.calculateDivider(splitDockStation, putInfo, leaf);
        }
        if ((d = this.sizeManager.getSize(dockable)) < 0.0) {
            super.calculateDivider(splitDockStation, putInfo, leaf);
        } else {
            SplitNode splitNode = putInfo.getNode();
            Dimension dimension = dockable.getComponent().getSize();
            int n = Math.min(dimension.width, dimension.height);
            double d2 = 0.5;
            if (putInfo.getPut() == PutInfo.Put.TOP) {
                d2 = this.validateDivider(splitDockStation, d, DEFAULT_MINIMUM_SIZE, DEFAULT_MINIMUM_SIZE, SplitDockStation.Orientation.VERTICAL, splitNode.getWidth(), splitNode.getHeight());
                if (d2 > 0.75) {
                    d2 = 0.75;
                }
            } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
                d2 = this.validateDivider(splitDockStation, 1.0 - d, DEFAULT_MINIMUM_SIZE, DEFAULT_MINIMUM_SIZE, SplitDockStation.Orientation.VERTICAL, splitNode.getWidth(), splitNode.getHeight());
                if (d2 < 0.25) {
                    d2 = 0.25;
                }
            } else if (putInfo.getPut() == PutInfo.Put.LEFT) {
                d2 = this.validateDivider(splitDockStation, d, DEFAULT_MINIMUM_SIZE, DEFAULT_MINIMUM_SIZE, SplitDockStation.Orientation.HORIZONTAL, splitNode.getWidth(), splitNode.getHeight());
                if (d2 > 0.75) {
                    d2 = 0.75;
                }
            } else if (putInfo.getPut() == PutInfo.Put.RIGHT && (d2 = this.validateDivider(splitDockStation, 1.0 - d, DEFAULT_MINIMUM_SIZE, DEFAULT_MINIMUM_SIZE, SplitDockStation.Orientation.HORIZONTAL, splitNode.getWidth(), splitNode.getHeight())) < 0.25) {
                d2 = 0.25;
            }
            putInfo.setDivider(d2);
            putInfo.setOldSize(n);
        }
    }
}

