/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.station.split;

import bibliothek.extension.gui.dock.station.split.SizeManager;
import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.event.DockRelocatorAdapter;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DockFrontendSizeManager
implements SizeManager {
    private Map<Dockable, Double> sizes = new HashMap<Dockable, Double>();
    private DockFrontend frontend;
    private DockRelocatorListener relocatorListener = new DockRelocatorAdapter(){

        public void init(DockController dockController, Dockable dockable) {
            double d;
            if (DockFrontendSizeManager.this.needToTrackChange(dockable) && (d = DockFrontendSizeManager.this.computeRelativeSizeOfDockable(dockable)) >= 0.0) {
                DockFrontendSizeManager.this.put(dockable, d);
            }
        }
    };
    private DockFrontendListener frontendListener = new DockFrontendAdapter(){

        public void removed(DockFrontend dockFrontend, Dockable dockable) {
            DockFrontendSizeManager.this.sizes.remove(dockable);
        }
    };
    private AdjacentDockFactory<Double> sizeConverter = new AdjacentDockFactory<Double>(){

        @Override
        public boolean interested(DockElement dockElement) {
            return DockFrontendSizeManager.this.sizes.containsKey(dockElement);
        }

        @Override
        public String getID() {
            return "dock.extension.DockFrontendSizeManager.sizes";
        }

        @Override
        public Double getLayout(DockElement dockElement, Map<Dockable, Integer> map) {
            return (Double)DockFrontendSizeManager.this.sizes.get(dockElement);
        }

        @Override
        public Double read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
            return dataInputStream.readDouble();
        }

        @Override
        public Double read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
            return xElement.getDouble();
        }

        @Override
        public void setLayout(DockElement dockElement, Double d, Map<Integer, Dockable> map) {
            this.setLayout(dockElement, d);
        }

        @Override
        public void setLayout(DockElement dockElement, Double d) {
            Dockable dockable = dockElement.asDockable();
            if (dockable != null) {
                DockFrontendSizeManager.this.sizes.put(dockable, d);
            }
        }

        @Override
        public void write(Double d, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeDouble(d);
        }

        @Override
        public void write(Double d, XElement xElement) {
            xElement.setDouble(d);
        }
    };

    public double getSize(Dockable dockable) {
        Double d = this.sizes.get(dockable);
        if (d == null) {
            return -1.0;
        }
        return d;
    }

    public void setFrontend(DockFrontend dockFrontend) {
        if (this.frontend != dockFrontend) {
            if (this.frontend != null) {
                this.frontend.getController().getRelocator().removeDockRelocatorListener(this.relocatorListener);
                this.frontend.removeFrontendListener(this.frontendListener);
                this.frontend.unregisterAdjacentFactory(this.sizeConverter);
                this.sizes.clear();
            }
            this.frontend = dockFrontend;
            if (this.frontend != null) {
                this.frontend.getController().getRelocator().addDockRelocatorListener(this.relocatorListener);
                this.frontend.addFrontendListener(this.frontendListener);
                this.frontend.registerAdjacentFactory(this.sizeConverter);
            }
        }
    }

    protected boolean needToTrackChange(Dockable dockable) {
        Root root;
        SplitNode splitNode;
        SplitDockStation splitDockStation = this.getFirstAncestorSplitDockStation(dockable);
        boolean bl = false;
        if (splitDockStation != null && (splitNode = (root = splitDockStation.getRoot()).getChild()) instanceof Node) {
            bl = true;
        }
        return bl;
    }

    private double computeRelativeSizeOfDockable(Dockable dockable) {
        double d = -1.0;
        SplitDockStation splitDockStation = this.getFirstAncestorSplitDockStation(dockable);
        if (splitDockStation != null) {
            SplitNode splitNode = splitDockStation.getRoot().getChild();
            double d2 = 0.0;
            double d3 = 0.0;
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.HORIZONTAL;
            if (splitNode instanceof Node) {
                orientation = ((Node)splitNode).getOrientation();
            }
            Insets insets = splitDockStation.getBasePane().getInsets();
            if (orientation == SplitDockStation.Orientation.HORIZONTAL) {
                d2 = splitDockStation.getWidth() - insets.left - insets.right;
                d3 = dockable.getComponent().getWidth();
            } else {
                d2 = splitDockStation.getHeight() - insets.top - insets.bottom;
                d3 = dockable.getComponent().getHeight();
            }
            d = d3 / d2;
        }
        if (Double.isNaN(d)) {
            d = -1.0;
        }
        return d;
    }

    private SplitDockStation getFirstAncestorSplitDockStation(Dockable dockable) {
        DockStation dockStation;
        Dockable dockable2 = dockable;
        while ((dockStation = dockable2.getDockParent()) != null) {
            if (dockStation instanceof SplitDockStation) {
                return (SplitDockStation)dockStation;
            }
            dockable2 = dockStation.asDockable();
            if (dockable2 != null) continue;
            return null;
        }
        return null;
    }

    private void put(Dockable dockable, double d) {
        this.sizes.put(dockable, d);
    }
}

