% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R, R/alignmentFunctions.R
\name{timeAlign}
\alias{timeAlign}
\alias{timeAlign,SpectraInTime,ProcessTimes-method}
\alias{timeAlign,list,ProcessTimesFrame-method}
\alias{timeAlign,list,character-method}
\title{Time align first object, using info in the second object}
\usage{
timeAlign(x, y, ...)

\S4method{timeAlign}{SpectraInTime,ProcessTimes}(x, y, cutCooling = FALSE, cutBeforeMinTemp = FALSE)

\S4method{timeAlign}{list,ProcessTimesFrame}(x, y, cutCooling = FALSE, cutBeforeMinTemp = FALSE)

\S4method{timeAlign}{list,character}(
  x,
  y,
  cutCooling = FALSE,
  cutBeforeMinTemp = FALSE,
  timeFormat = "\%Y-\%m-\%d \%H:\%M:\%S"
)
}
\arguments{
\item{x}{and S4 object to be aligned}

\item{y}{object to use time information from}

\item{...}{additional arguments}

\item{cutCooling}{logical indicator if \code{TRUE} observation after cooling starts are cut off, defaults to \code{FALSE}}

\item{cutBeforeMinTemp}{logical indicator if \code{TRUE} observation before minimum temperature are cut off, defaults to \code{FALSE}}

\item{timeFormat}{character vector specifying time format \code{\link[base]{as.POSIXct}}}
}
\value{
\code{\link{SpectraInTime-class}} or list of spectra depending on input
}
\description{
Time align first object, using info in the second object
}
\examples{

 spectra             <-  getSpectraInTimeExample()
 listOfSpectra       <-  getListOfSpectraExample()
 processTimes        <-  getProcessTimesExample()
 processTimesFrame   <-  getProcessTimesFrameExample()
 pathProcessTimes    <-  getPathProcessTimesExample()
  
ex1  <-  timeAlign( x = spectra , y = processTimes ,
 cutCooling = TRUE , cutBeforeMinTemp = TRUE )
ex2  <-  timeAlign( x = listOfSpectra , y = processTimesFrame ,
 cutCooling = TRUE , cutBeforeMinTemp = TRUE )
ex3  <-  timeAlign( x = listOfSpectra , y = pathProcessTimes, 
 cutCooling = TRUE , cutBeforeMinTemp = TRUE  , timeFormat =  "\%Y-\%m-\%d \%H:\%M:\%OS" )
}
