% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectraDataFrame-methods.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{subset.SpectraDataFrame}
\alias{subset,SpectraDataFrame-method}
\title{Subset SpectraDataFrame object}
\usage{
subset(x, ...)
}
\arguments{
\item{x}{SpectraDataFrame object}

\item{...}{see details below}
}
\value{
SpectraDataFrame object
}
\description{
Returns subsets of a SpectraDataFrame object.
}
\details{
Additional parameters:
\describe{
  \item{subset}{logical expression indicating elements or rows to keep: missing values are taken as false}
  \item{select}{expression, indicating columns to select from the data slot}
  \item{drop}{passed on to "[" indexing operator}
  \item{...}{Additional arguments}
}
}
\examples{

# Loading example data
data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500

# Subset on attributes
s <- subset(australia, carbon < 5)

# Subset and selection of attributes
s <- subset(australia, carbon < 5, select = 1)
}
\seealso{
\code{\link{mutate}}
}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
