% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SilhouetR.R
\name{SilhouetR}
\alias{SilhouetR}
\title{SilhouetR}
\usage{
SilhouetR(DataMatrix, GroupIndices, distance = "euclid", stand = TRUE)
}
\arguments{
\item{DataMatrix}{a matrix with the raw data, 1 variable per column.}

\item{GroupIndices}{The vector with the group indices (length must be equal to the amount of rows in DataMatrix).}

\item{distance}{The distance metric to be used, see \link[cluster]{daisy}.}

\item{stand}{whether to standardize the data before calculating the dissimilarities. See \link[cluster]{daisy}.}
}
\value{
Returns the silhouette values. Note if a group contains only 1 no Silhouette value can be calculated (will give NA)
}
\description{
Calculate the Silhouette value for
}
\examples{
subset <- GetWinedata.subset()
# to reduce the example time we only select spectra 1 & 2
subset.spectra = as.matrix(subset$Spectra)[1:2,] 
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm,
                              nCPU = 1) # nCPU set to 2 for the vignette build
                              
test.grouped <- PeakGrouper(Y.peaks = test.peaks)

Silhouette.values = SilhouetR(DataMatrix = test.grouped$peakPPM, 
                              test.grouped$peakIndex, 
                              distance = 'euclid', 
                              stand = TRUE)
                              
hist(Silhouette.values$SilhouetteValues)


}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
