% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{praat_plot}
\alias{praat_plot}
\title{Plot waveform and spectrogram}
\usage{
praat_plot(
  file,
  wav,
  tg = NULL,
  start = 0,
  end = NULL,
  width = 5,
  format = "png",
  f0 = FALSE,
  f0_min = 0,
  f0_max = 500,
  spec_max = 5000
)
}
\arguments{
\item{file}{Output file path as a string.}

\item{wav}{Wav file path as a string.}

\item{tg}{TextGrid file path as a string. If `NULL` (the default), a TextGrid
is plotted if a TextGrid file with the same name as the wav file is found.
No TextGrid is plotted otherwise.}

\item{start}{Start time of the plotting window in seconds.}

\item{end}{End time of the plotting window in seconds. If `NULL` (the
default), plot the entire duration.}

\item{width}{Width of the plot in inches.}

\item{format}{Output file format (`png` by default, or `pdf`).}

\item{f0}{Whether to plot f0 (`FALSE` by default).}

\item{f0_min}{If `f0 = TRUE`, minimum f0 value (`0` by default).}

\item{f0_max}{If `f0 = TRUE`, maximum f0 value (`500` by default).}

\item{spec_max}{Maximum frequency for the spectrogram (`5000` by default).}
}
\value{
Nothing. It is used for its side effects.
}
\description{
Plot waveform and spectrogram
}
\examples{
\dontrun{
wav <- system.file("extdata", "vowels.wav", package = "speakr")

praat_plot("vowels.png", wav, f0 = TRUE, f0_max = 200, end = 3)
}
}
